import java.util.*;

/** software library  */

public class comm implements Runnable
{
    private int port ; /* port on which client will send  */ 
    private static int ID ;   /* unique id .  will get from the server at initialization*/
    private static int CTR;   /* to count number of messages sent . will increase monotonically */
    private static int MID;   /* Message id. used for tracking sequence of messages : abcast,abcast_ack,abcast2  */

    final static int READ=1;
    final static int WRITE=2;
    final static int ABCAST=0;
    final static int ABCAST_ACK=1;
    final static int ABCAST2=2;
    final static int PROBE=3;
    final static int PROBE_ACK=4;
    final static int UNDELIVERABLE=0;
    final static int DELIVERABLE=1;
    final static int CLIENT=0;
    final static int SERVER=1;



    private Abcast a;    
    private Message m,mab2;
    private AbcastAck aack;
    private Abcast2 a2,ab2;
    private CoreMessage cm;


    private Hashtable causalCheck;         
               /* contains client_id and last message delivered -- both string objects */
    private Hashtable causalQueue ;
               /* contains "client_id + messagenum" and Message object  */
    private TreeMap  abcastQueue ;
               /* contains "priority + client_id "  and Message object */
    private Hashtable abcastAckSet ;
               /* contains abcast_ack received by the clients sent by the servers */
               /* contains "client_id + message_ID" and SetObject */
    SetObject so;        
               /*  contains priority, HashSet containing unique identity String */
               /*  each client will have one */
               /* an entry will be added when an Abcast message is sent */

    Object o;


    public static int getUniqueID()
    {
	return comm.ID;
    }


    /*  initialization of comm module */


    public comm(int ID, int port, int X, int ReceiverType)  // int X is boolean to differentiate between client and server.

    {
	comm.ID=ID;   /* initialise this client/server with a unique identitification */ 
	this.CTR=1;
	this.MID=1;
	causalCheck = new Hashtable();  
	causalQueue = new Hashtable();
	abcastQueue = new TreeMap(new CompareString());
	abcastAckSet = new Hashtable();
	so = new SetObject();

	
	DataComm_app.init();  /* initialises the data structure between Application layer and comm module */
	DataSR_comm.init();   /* initialises the data structure between comm module and the lower layer */

	Thread sender=new Thread(new Send(port));   /*  instantiate the sender , which will open the send port */  
    

	/*   instantiate the receiver  , which will open the receive port at address (port + 1)  from listening  */  
	/*   threee types of receivers : */
        /*   multicast receive , point to point receive , and both multicast and point to point  */    

	if (ReceiverType==0)
	    {
		Thread t=new Thread(new ReceiveP2P(port+1));
		t.start();
	    }
	else if (ReceiverType==1)
	    {
		Thread t=new Thread(new ReceiveMulticast());
		t.start();
	    }
	else
	    {
		Thread t1=new Thread(new ReceiveP2P(port+1));
		Thread t2=new Thread(new ReceiveMulticast());
		t1.start();
		t2.start();
	    }

	sender.start();   /*   start sender thread :  single port for all types ( multicast and point to point ) */

}



    public void run()     /*  thread of comm module starts from here  */

    {
	Thread a1 = new Thread(new ConsumeFromApp());
	Thread a2 = new Thread(new ConsumeFromDown());
	a1.start();
	a2.start();

    }

    	       


    /* ----------------------------------------------------------------- */



    public synchronized static int getCounterValue()
    {

	return comm.CTR++;  /*  vector time of the process */
	/* increments every time a message is sent */
    }


    /* ----------------------------------------------------------------- */

    public synchronized static  int getMessageID()
    {
	return comm.MID++;  /* message identification  */
    }


    /* ----------------------------------------------------------------- */




    /*   read write primitives invoked by the application layer      */

    /*   send ABCAST Message                                         */




    /* ------------------------------------------------------------- */



  }






