import java.util.*;

/** software library  */

public class comm implements Runnable
{
    private int port ;
    private int ID ;  /* unique id .  will get from the server at initialization*/
    private int CTR;   /* to count number of messages sent . will increase monotonically */
    private int MID;   /* Message id. used for tracking sequence of messages : abcast,abcast_ack,abcast2  */

    final static int READ=1;
    final static int WRITE=2;
    final static int ABCAST=0;
    final static int ABCAST_ACK=1;
    final static int ABCAST2=2;
    final static int PROBE=3;
    final static int PROBE_ACK=4;
    final static int UNDELIVERABLE=0;
    final static int DELIVERABLE=1;
    final static int CLIENT=0;
    final static int SERVER=1;



    private Abcast a;
    private Message m,mab2;
    private AbcastAck aack;
    private Abcast2 a2;
    private CoreMessage cm;
    // private Send s;
    // private ReceiveMulticast rm;
    // private ReceiveP2P rp2p;

    private Hashtable causalCheck;         
               /* contains client_id and last message delivered -- both string objects */
    private Hashtable causalQueue ;
               /* contains "client_id + messagenum" and Message object  */
    private TreeMap  abcastQueue ;
               /* contains "priority + client_id "  and Message object */
    private Hashtable abcastAckSet ;
               /* contains abcast_ack received by the clients sent by the servers */
               /* contains "client_id + message_ID" and SetObject */
    SetObject so;   
               /*  contains priority, HashSet containing unique identity String */
               /*  each client will have one */
               /* an entry will be added when an Abcast message is sent */

    Object o;
    DataComm_app d;



    /*  initialization of comm module */


    public comm(int ID, int port, int X, int ReceiverType)  // int X is boolean to differentiate between client and server.

{
    this.ID=ID;   /* initialise this client/server with a unique identitification */ 
    this.CTR=1;
    this.MID=1;
    causalCheck = new Hashtable();  
    causalQueue = new Hashtable();
    abcastQueue = new TreeMap(new CompareString());
    abcastAckSet = new Hashtable();
    so = new SetObject();
    d =new DataComm_app(); 
    //  initializes lower layer
    Thread sender=new Thread(new Send(port));
    sender.start(); 
    if (ReceiverType==0)
	{
	    Thread t=new Thread(new ReceiveP2P(port+1));
	    t.start();
	}
    else if (ReceiverType==1)
	{
	    Thread t=new Thread(new ReceiveMulticast());
	    t.start();
	}
    else
	{
	    Thread t1=new Thread(new ReceiveP2P(port+1));
	    Thread t2=new Thread(new ReceiveMulticast());
	    t1.start();
	    t2.start();
	}
}



    public void initLowerLayer(int ID, int port, int X)
    {



    }   





    public void run()
    {

	System.out.println(" I entered void run of comm  ");

	while(true)
	    {

		if (!DataComm_app.App_comm.isEmpty())
		    {

			System.out.println("in the comm module : App has sent something  ");
			o = DataComm_app.getApp_comm();  /* received from App layer */
			if (o.getClass().isInstance(new CoreMessage()))
			    {
				processMessage((CoreMessage)o);
			    }
			else  // we will use only 1 type of message. hence else will never be true.
			    {
				System.out.println(" message  not a string ");

			    }

		    }

		else
		    {

			if (!DataSR_comm.SR_comm.isEmpty())   //   receive from lower layer 
			{
			    System.out.println("in the comm module : SR  has sent something  ");
			    Message m  = (Message)DataSR_comm.getSR_comm();  /* received from App layer */
			    /*   RECEIVE PRIMITIVE */
			    /*  this will receive all messages and prcess them appropriately */

			    switch (m.getmessagetype())
				{
				case ABCAST:{ processAbcast(m);}break;
				case ABCAST_ACK:{ processAbcastAck(m);}break;
				case ABCAST2: {processAbcast2(m);} break;
				case PROBE: {processProbe(m);} break;
				case PROBE_ACK: {processProbeAck(m);} break;
				}

			}


		    else
			{
			    System.out.println("in the comm module : no message from App or Lower Layer ");
			}

		    }
		
	    }
    }
    
    


    /* ----------------------------------------------------------------- */



    public synchronized int getCounterValue()
    {
	return CTR++;  /*  vector time of the process */
	/* increments every time a message is sent */
    }


    /* ----------------------------------------------------------------- */

    public synchronized int getMessageID()
    {
	return MID++;  /* message identification  */
    }


    /* ----------------------------------------------------------------- */




    /*   read write primitives invoked by the application layer      */

    /*   send ABCAST Message                                         */


    public void processMessage(CoreMessage cm)
    {
	if(cm.getType() == READ)

	    {
		a=new Abcast(cm,READ);
		m=new Message(ID,ABCAST,this.getMessageID(),0,a,this.getCounterValue());
		m.setmessagegrp(0);  //  message group id is 0;
		DataSR_comm.addComm_SR(m);
		//	this.send(m);   this was the old primitive .  
	    }
	else   /* cm.getType == READ) */
	    {
		/* include WRITE OPERATION  */
	    }

    }










    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */




    /*   read write primitives invoked by this layer and passed to the lower layer      */


    //  this  method is deprecated.  will not be used .

    public void send(Message m, int gid)
    {
	//s.sendTo(M);  // this mechanism will be determined later.
	// low level interface.

	/* 
	   this primitive has to differentiate between multicast and unicast.
	   both have gid 
	   example Absact send and AbcastAck sent
	*/

    }



    /* ------------------------------------------------------------- */






    /* ------------------------------------------------------------- */


    /** server executes this methods */

    public void processAbcast(Message m)
    {

	/* Phase -I check for causal order */
	
	if (causalCheck.containsKey(""+m.getmessagesource()))
	    {
		int x = Integer.parseInt((String)causalCheck.get(""+m.getmessagesource()));
		if( x == m.getmessagenum() - 1)
		    {
			causalCheck.put(""+m.getmessagesource(),""+(x+1));
			

	/* Phase -II Atomicity and total ordering */
			

			((Abcast)m.getmessageobj()).setmessagestatus(UNDELIVERABLE);
			String u = new String (""+ 0 + "#" + m.getmessagesource() + "#" + m.getmessageid()); 
			abcastQueue.put(u,m);  // change it later 
			sendAbcastAck(m,this.getCounterValue());

			//check list of waiting messages in causal_queue
			check(m);  /*  recursive call */
			
		    }

		else 
		    {
			causalQueue.put(""+m.getmessagesource()+"#"+m.getmessagenum(),m);
		    }

	    }

	else 
	    {
		
		causalCheck.put(""+m.getmessagesource(),""+m.getmessagenum());
		/* Phase -II Atomicity and total ordering */
		//second phase starts for the first message recived from a client
		((Abcast)m.getmessageobj()).setmessagestatus(UNDELIVERABLE);
		String u = new String (""+ 0 + "#" + m.getmessagesource() + "#" + m.getmessageid()); 
		abcastQueue.put(u,m);  // change it later 
		sendAbcastAck(m,this.getCounterValue());

		
	    }

    }



    /* ------------------------------------------------------------- */



    public void processAbcast2(Message m)

    {   




	/* Phase -I check for causal order */

	if (causalCheck.containsKey(""+m.getmessagesource()))
	    {
		int x = Integer.parseInt((String)causalCheck.get(""+m.getmessagesource()));
		if( x == m.getmessagenum() - 1)
		    {
			causalCheck.put(""+m.getmessagesource(),""+(x+1));
			

	/* Phase -2 Atomicity and total ordering */

			/*   data structure to be defined */
		
			/*

			abcastQueue.put(""+m.getmessagesource(),m);
			*/
			
			String v = new String( 0+"#"+ m.getmessagesource() + "#" + m.getmessageid()); 
			Message newm = (Message)abcastQueue.remove(v);

			((Abcast2)newm.getmessageobj()).setpriority( ((Abcast2)m.getmessageobj()).getpriority());
			((Abcast)newm.getmessageobj()).setmessagestatus(DELIVERABLE);

			v = new String( ((Abcast)newm.getmessageobj()).getpriority() + "#"+ m.getmessagesource() + "#" + m.getmessageid() );
			abcastQueue.put(v,newm); 
			processAbcastQueue();




		    }

		else 
		    {
			causalQueue.put(""+m.getmessagesource()+"#"+m.getmessagenum(),m);
		    }

	    }

	else 
	    {
		

		causalCheck.put(""+m.getmessagesource(),""+m.getmessagenum());
		//second phase starts for the first message recived from a client

			String v = new String( 0+"#"+ m.getmessagesource() + "#" + m.getmessageid()); 
			Message newm = (Message)abcastQueue.remove(v);

			((Abcast2)newm.getmessageobj()).setpriority( ((Abcast2)m.getmessageobj()).getpriority());
			((Abcast)newm.getmessageobj()).setmessagestatus(DELIVERABLE);

			v = new String( ((Abcast)newm.getmessageobj()).getpriority() + "#"+ m.getmessagesource() + "#" + m.getmessageid() );
			abcastQueue.put(v,newm); 
			processAbcastQueue();

			/*   old code
		((Abcast)m.getmessageobj()).setmessagestatus(UNDELIVERABLE);
		abcastQueue.put(""+m.getmessagesource(),m);
		sendAbcastAck(m,CTR);
		CTR++;
			*/
		
	    }



	
    }


    public synchronized void processAbcastQueue()
    {

	/*  to deliver message whose status bit is "DELIVERABLE" */

	boolean flag = true;
	Message dm;
	while (flag)
	    {
		
		dm = (Message) abcastQueue.lastKey();
		if(  ((Abcast)dm.getmessageobj()).getmessagestatus() == DELIVERABLE  )
		    {
		       DataComm_app.addComm_app(abcastQueue.remove(abcastQueue.lastKey()));
		    }
		else flag = false;
	    }

    }




    /* ------------------------------------------------------------- */





    public void sendAbcastAck(Message m,int priority)

    {
	
	AbcastAck aack = new AbcastAck(priority);
	Message mack = new Message(ID,ABCAST_ACK,m.getmessageid(),m.getgid(),aack,priority /*CTR*/);
	/* here priority and CTR will have the same value */

	mack.setmessagegrp(-1);
	mack.setmessagedest(m.getmessagesource());
	DataSR_comm.addComm_SR(mack);

	//	send(mack,m.getmessagesource());   old code .
	/* send this message to only one source */


    } 



    public void processAbcastAck(Message m)

    {

	String s = new String(m.getmessagesource()+"#"+m.getmessageid());
	SetObject so = (SetObject)abcastAckSet.get(s);
	so.setpriority( ((AbcastAck)m.getmessageobj()).getpriority() );
	so.remove(s);  
	if (so.isEmpty())
	    {  
		Abcast2 ab2 = new Abcast2(so.getpriority()); 
		mab2 = new Message(ID,ABCAST2,m.getmessageid(),0,ab2,this.getCounterValue());  //gid is hard-coded as 0

	    }
    }   


    /*   included in processAbcastAck 
    public void sendAbcast2(Message m)
    {

    } 
    */


    public void processProbe(Message m)
    {
	
    }

    public void processProbeAck(Message m)
    {
	
    }


    /* ------------------------------------------------------------- */



    public void check(Message m)
    {

	/* i think m.getmessageid() should be incremented by 1 */
	if(causalQueue.contains(m.getmessagesource()+"#"+(m.getmessagenum()+1)))
	    {
		causalCheck.put(""+m.getmessagesource(),""+(m.getmessagenum()+1));
		//second phase starts
		Message temp=(Message)causalQueue.get(m.getmessagesource()+"#"+(m.getmessagenum() +1 ));
		((Abcast)temp.getmessageobj()).setmessagestatus(UNDELIVERABLE);
		abcastQueue.put(""+temp.getmessagesource(),temp); // check this later
		sendAbcastAck(temp,this.getCounterValue());
		check(temp);
	    }
	else
	    {
		return;
	    }
	
    }

    /* ------------------------------------------------------------- */


  }














