import java.io.*;
import java.util.Hashtable;
import javax.servlet.*;
import javax.servlet.http.*;
//import Maptest;
import ims.newservice.*;
import ims.renderers.*;
import java.util.Enumeration;
import java.util.*;

public class SimpleServlet extends HttpServlet
{ 
    static int serviceNo=0;
    params parameters;
    
    /**
     * Handle the HTTP POST method 
     */
    public void doPost (HttpServletRequest request,
			HttpServletResponse response)
        throws ServletException, IOException
    {
	PrintWriter out;
	String 	dataToSend="";
	
	// Use these for file read operations
	int 	c;
	File 	fp1=null;
	FileReader fr1=null;
	char[] 	cbuf;
	
	// Parameters passed to servlet
	String	service = request.getParameter("service");
	String	axl = request.getParameter("request");
	String	cmd = request.getParameter("cmd");
	String srvcName="ERROR";
	
	try {
	    // set content type and other response header fields first
	    //System.out.println("Startingservlet");
	    response.setContentType("text/plain");
  	    parameters=new params();
	    
	    if(cmd.equals("GETMETADATA"))  {
		System.out.println("*********************************");
		System.out.println("REQUEST FOR GETMETADATA");
		System.out.println("*********************************");
		String str=parameters.getParameters();
		fp1=new File("/data/list13/local/ArcIMS/AXL/Maps.axl");
		fr1=new FileReader(fp1);
		cbuf=new char[(int)fp1.length()];
		fr1.read(cbuf);
		fr1.close();
		fp1=null;
		dataToSend=new String(cbuf)+";;"+str;
		System.out.println("*********************************");
		System.out.println("END GETMETADATA");
		System.out.println("*********************************");
	    }
	    else if(cmd.equals("STARTSERVICE")) {
		System.out.println("*********************************");
		System.out.println("REQUEST FOR STARTSERVICE");
		System.out.println("*********************************");
		try {
		    String axlStr;
		    servletXMLParse xp=new servletXMLParse();
		    System.out.println("*********************************");
		    System.out.println("Call doParse with ORDER");
		    System.out.println("*********************************");
		    Hashtable orderedLayers=xp.doParse(axl,null,"ORDER");
		    Enumeration en=orderedLayers.keys();
		    while(en.hasMoreElements()) {
				Integer enkey=(Integer)en.nextElement();
				System.out.println("key:"+enkey+":"+(String)orderedLayers.get(enkey));
			}
		    System.out.println("*********************************");
		    System.out.println("End of doParse with ORDER");
		    System.out.println("*********************************");
		    System.out.println("*********************************");
		    System.out.println("Call doParse with METADATA");
		    System.out.println("*********************************");
		    Hashtable lyrs=xp.doParse(axl,null,"METADATA");
		    System.out.println("*********************************");
		    System.out.println("End of doParse with METADATA");
		    System.out.println("*********************************");
		    
		    axlStr=getNewServiceAXL(lyrs,orderedLayers);
		    System.out.println("new service AXL:\n"+axlStr);
		    srvcName=startupService(axlStr);
		    init();
		    dataToSend=srvcName;
		} catch (Exception en) {
		    en.printStackTrace();
		    dataToSend="ERROR";
		}
		System.out.println("*********************************");
		System.out.println("END STARTSERVICE");
		System.out.println("*********************************");
	    }
	    else if(cmd.equals("GETRENDERERINFO")) {
		System.out.println("*********************************");
		System.out.println("REQUEST FOR GETRENDERERINFO");
		System.out.println("*********************************");
		String lID=axl;
		String srvc=service;
		dataToSend=getLayerAXL(lID,srvc);
		dataToSend=dataToSend.replace('&','#');
		//System.out.println("Sending data :"+dataToSend);
		System.out.println("*********************************");
		System.out.println("END GETRENDERERINFO");
		System.out.println("*********************************");
	    }
	    out=response.getWriter();
	    out.print(dataToSend);
	    out.close();
	    //System.out.println("Finished sending data"+dataToSend);
	}
	catch (Exception ex) {
	    ex.printStackTrace();
	    dataToSend="Error in servlet";
	}
	//System.out.println("Send data");
    }

    public void init()
    {
	System.gc();
    }
    
    public String getNewServiceAXL(Hashtable lyrs,Hashtable oLyrs)
    {
    	Hashtable newLayers=getLayerInfo(lyrs);
	String paramstr=parameters.getParameters();
	System.out.println("Generating new axl now " + newLayers.size());
	Enumeration en=newLayers.keys();
        String lStr;
        Layer newLayer;
        String serviceAXL;
        Hashtable wspaces=new Hashtable();

        serviceAXL="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+
                "<ARCXML version=\"1.1\"> <CONFIG><MAP>\n"+
                "<ENVIRONMENT>\n" +
                "     <LOCALE country=\""+parameters.getParam("ENVIRONMENT-LOCALE-country")+"\" language=\""+parameters.getParam("ENVIRONMENT-LOCALE-language")+"\" variant=\""+parameters.getParam("ENVIRONMENT-LOCALE-variant")+"\" />\n" +
                "<UIFONT name=\""+parameters.getParam("ENVIRONMENT-UIFONT-name")+"\" size=\""+parameters.getParam("ENVIRONMENT-UIFONT-size")+"\" style=\""+parameters.getParam("ENVIRONMENT-UIFONT-style")+"\" />\n" +
                "<SCREEN dpi=\""+parameters.getParam("ENVIRONMENT-SCREEN-dpi")+"\" />\n" +
                "</ENVIRONMENT>\n" +
                "<PROPERTIES>\n" +
 "<ENVELOPE minx=\""+parameters.getParam("PROPERTIES-ENVELOPE-minx")+"\" miny=\""+parameters.getParam("PROPERTIES-ENVELOPE-miny")+"\" maxx=\""+parameters.getParam("PROPERTIES-ENVELOPE-maxx")+"\" maxy=\""+parameters.getParam("PROPERTIES-ENVELOPE-maxy")+"\" name=\"Initial_Extent\" />\n" +
        "<MAPUNITS units=\""+parameters.getParam("PROPERTIES-MAPUNITS-units")+"\" />\n" +
        "<FILTERCOORDSYS id=\""+parameters.getParam("PROPERTIES-FILTERCOORDSYS-id")+"\" />\n" +
        "<FEATURECOORDSYS id=\""+parameters.getParam("PROPERTIES-FEATURECOORDSYS-id")+"\" />\n" +
                "</PROPERTIES>\n" +
                "<WORKSPACES>\n";
        String str;
        while(en.hasMoreElements()) {
		lStr=(String)en.nextElement();
		newLayer=(Layer)newLayers.get(lStr);
                str=newLayer.getWorkspace();
                if(!wspaces.containsKey(str)) {
                        wspaces.put(str,str);
                }
        }
        en=wspaces.keys();
        while(en.hasMoreElements()) {
                lStr=(String)en.nextElement();
                serviceAXL+=lStr+"\n";
        }
        serviceAXL+="\n</WORKSPACES>\n";
        en=newLayers.keys();
	int id=0;
	int k=0;
        //while(en.hasMoreElements()) {
	String lKey;
	for(k=0;k<newLayers.size();k++) {
		lStr=(String)oLyrs.get(new Integer(k));
		System.out.println("Fetching key:"+lStr);
                //lStr=(String)en.nextElement();
                newLayer=(Layer)newLayers.get(lStr);
                serviceAXL+="\n<LAYER ";
                serviceAXL+=" type=\""+newLayer.getType()+"\"";
                serviceAXL+=" name=\""+newLayer.getName()+"\"";
                serviceAXL+=" visible=\"true\"";
                //serviceAXL+=" id=\""+newLayer.getID()+"\">\n";
                serviceAXL+=" id=\""+id+"\">\n";
		id++;

                if(newLayer.getDataset()!=null)
                serviceAXL+=newLayer.getDataset()+"\n";

		//System.out.println("getting renderers here");
                serviceAXL+=getRendererAXL(newLayer)+"\n";

                if(newLayer.getCoordsys()!=null)
                serviceAXL+=newLayer.getCoordsys()+ "\n";

                serviceAXL+="</LAYER>"+"\n";
	 }
        //}
        serviceAXL+="</MAP>\n</CONFIG>\n</ARCXML>";
        //System.out.println(serviceAXL);
	return(serviceAXL);
    }
	
    public String getRendererAXL(Layer nLayer)
    {
	String rendererType=nLayer.getRendererType();
	String axlStr="### " + rendererType+" renderer for "+nLayer.getID();
	//System.out.println("RendererType");
	//System.out.println(rendererType);
	
  	if(rendererType!=null) {
		if(rendererType.equals("GROUPRENDERER")) {
			GroupRenderer g1=(GroupRenderer)nLayer.getRenderer();
			axlStr=g1.getXML();
		}
		else if(rendererType.equals("SCALEDEPENDENTRENDERER")) {
			ScaleDependentRenderer g1=(ScaleDependentRenderer)nLayer.getRenderer();
			axlStr=g1.getXML();
		}
		else if(rendererType.equals("SIMPLELABELRENDERER")) {
			SimpleLabelRenderer g1=(SimpleLabelRenderer)nLayer.getRenderer();
			axlStr=g1.getXML();
		}
		else if(rendererType.equals("SIMPLERENDERER")) {
			SimpleRenderer g1=(SimpleRenderer)nLayer.getRenderer();
			axlStr=g1.getXML();
		}
		else if(rendererType.equals("VALUEMAPRENDERER")) {
			ValueMapRenderer g1=(ValueMapRenderer)nLayer.getRenderer();
			axlStr=g1.getXML();
		}
		else if(rendererType.equals("VALUEMAPLABELRENDERER")) {
			ValueMapLabelRenderer g1=(ValueMapLabelRenderer)nLayer.getRenderer();
			axlStr=g1.getXML();
		}
	}
	else {
		axlStr="<SIMPLERENDERER>\n"+
          	"<SIMPLEPOLYGONSYMBOL boundarytransparency=\"1.0\"\n"+
		" filltransparency=\"0.0\" boundarycaptype=\"round\"\n "+
		"boundarycolor=\"255,0,0\" />\n"+
        	"</SIMPLERENDERER>\n";
	}
	return(axlStr);
    }


    public String startupService(String serviceAXL)
    {
	//System.out.println("Starting up service :"+serviceNo);
	String srvcName="TESTSERVICE"+serviceNo;
	String xml="<?xml version=\"1.0\"?>" +
                        "<ADMINCMD version=\"1.0\">"+
                        "<SERVICES> "+

                        "<SERVICE type=\"add\" name=\"TESTSERVICE"+serviceNo+"\" axl=\"/data/list13/local/ArcIMS/AXL/new/service"+serviceNo+".axl\" vsname=\"ImageServer1\" imgloc=\"/data/list14/WebServer/WWW/htdocs/arcims3.1/output\" imgurl=\"http://hercules.csee.umbc.edu:9780/output\" imagememory=\"20\" cleanup=\"20\" imgtype=\"PNG8\" /> "+

                        "<SERVICE type=\"start\" name=\"TESTSERVICE"+serviceNo+"\" />"+
                        "</SERVICES>"+
                        "</ADMINCMD>";

	//System.out.println(xml);
	
	try {
	File fp1=new File("/data/list13/local/ArcIMS/AXL/new/service"+serviceNo+".axl");
	FileWriter fw=new FileWriter(fp1);
	char[] axlbuff=serviceAXL.toCharArray();
	fw.write(axlbuff);
	fw.close();
	

	fp1=new File("/data/list13/local/ArcIMS/AXL/new/startService"+serviceNo+".xml");
                        fw=new FileWriter(fp1);
                        axlbuff=xml.toCharArray();
                        fw.write(axlbuff);
                        fw.close();
	                       String s=null;
			//System.gc();
                        Process p = Runtime.getRuntime().exec("/data/list9/tmp/aimsServices/service /data/list13/local/ArcIMS/AXL/new/startService"+serviceNo+".xml");

                        BufferedReader stdInput = new BufferedReader(new
                                InputStreamReader(p.getInputStream()));

                        BufferedReader stdError = new BufferedReader(new
                                InputStreamReader(p.getErrorStream()));

                        // read the output from the command

			String resultStr="";
                        while ((s = stdInput.readLine()) != null) {
                                //System.out.println(s);
				resultStr+=s;
                        }
                        System.out.println("Here is the standard error of the command (if any):\n");
            while ((s = stdError.readLine()) != null) {
                System.out.println(s);
            }
		System.out.println("Found result "+resultStr);
	    	serviceNo++;
		if(resultStr.indexOf("failed")==-1) {
	     		return(srvcName);
		}
		else return("ERROR");
	}catch(Exception ex) { 
		ex.printStackTrace();}
		return("ERROR");
	
    }

    public Hashtable getLayerInfo(Hashtable lyrs)
    {
	Hashtable services=getServices(lyrs);
	Hashtable serviceInfo=new Hashtable();
	Hashtable serviceAXLInfo=new Hashtable();
	String serviceXML;
	String serviceAXL;
	String srvc;
	Hashtable layerInfo;
	Hashtable layers=new Hashtable();
	String layerAXL="";
	Enumeration en=services.keys();
	String layerid,serviceid;
	while(en.hasMoreElements()) {
		serviceXML=getServiceRequest();
		srvc=(String)en.nextElement();
		System.out.println("fetching for:"+srvc);
		serviceInfo.put(srvc,sendMapRequest(srvc,serviceXML));
		serviceAXLInfo.put(srvc,getAXL(srvc));
	}
	en=lyrs.keys();
	while(en.hasMoreElements()) {
		layerInfo=(Hashtable)lyrs.get((String)en.nextElement());
		layerid=(String)layerInfo.get("layerid");
		serviceid=(String)layerInfo.get("service");
		System.out.println("\n**************Starting with "+layerid+" of service "+serviceid+"**************");
		serviceXML=(String)serviceInfo.get(serviceid);
		serviceAXL=(String)serviceAXLInfo.get(serviceid);
		Layer ly=doParse(layerid,serviceXML,serviceAXL,serviceid);
		if(layerInfo.containsKey("renderer")) {
			System.out.println("Renderers modified");
			//System.out.println("updating renderer"+(String)layerInfo.get("renderertype"));
			ly.setRenderer(layerInfo.get("renderer"));
			ly.setRendererType((String)layerInfo.get("renderertype"));
		}
		layers.put(layerid+":"+serviceid,ly);
		//System.out.println("Final size of layers :"+layers.size());
		//System.out.println("**************FINISHED**************\n");
	}
	/*if(layers!=null) {
		System.out.println("got back "+layers.size()+" layers");
		Enumeration en1=layers.keys();
		while(en1.hasMoreElements()) {
			System.out.println((String)en1.nextElement());
		}
	}*/
	return(layers);
    }

    
    public Hashtable getServices(Hashtable lyrs)
    {
 	String srvc,key;
	Hashtable services=new Hashtable();
	Hashtable lInfo=new Hashtable();
	Enumeration en=lyrs.keys();
	//System.out.println("in getServices"+lyrs.size());
	while(en.hasMoreElements()) {
		key=(String)en.nextElement();
		lInfo=(Hashtable)lyrs.get(key);
		srvc=(String)lInfo.get("service");
		services.put(srvc,"null");
		//System.out.println("Found service :"+srvc);
	}
	//System.out.println("Found " + services.size()+" services");
	return(services);
    }

    public String getServiceRequest()
    {
	String serviceAXL="<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+
		"<ARCXML version=\"1.1\">"+
		"<REQUEST>"+
		"<GET_SERVICE_INFO dpi =\"1 - NNN\" "+
     		" envelope =\"true\"" +
     		" extensions =\"true\""+
     		" fields =\"true\"" +
     		" renderer =\"true\"/>" +
		"</REQUEST>"+
		"</ARCXML>";
	return(serviceAXL);
    }

    public String getAXL(String service)
    {
	try {
		String axlPath=getAXLPath(service);
		System.out.println("Got path:"+axlPath);
		File axlFile=new File(axlPath);
		FileReader fr1=new FileReader(axlFile);
		char[] buff=new char[(int)axlFile.length()];
		fr1.read(buff);
		fr1.close();
		axlFile=null;
		String axlVal=new String(buff);
		//System.out.println("Read in "+axlVal+ " from axl file");
		return(axlVal);
	} catch(Exception ex) {
		ex.printStackTrace();
		return(null);
	}
    }

    public String getAXLPath(String service)
    {
	try {
		File configFile=new File("/data/list9/tmp/aimsServices/services.ini");
		FileReader fr1=new FileReader(configFile);
		char[] buff=new char[(int)configFile.length()];
		fr1.read(buff);
		fr1.close();
		configFile=null;
		String config=new String(buff);
		String cEntry;
		int ind1,ind2;
		String sName;
		String sPath=null;
		while(config.indexOf(";;")!=-1) {
			ind1=config.indexOf(";;");
			cEntry=config.substring(0,ind1);
			cEntry.replace('\n',' ');
			sName=cEntry.substring(0,cEntry.indexOf(":"));
			sName=sName.trim();
			if(sName.equals(service)) {
				sPath=cEntry.substring(cEntry.indexOf(":")+1);
				break;
			}
			config=config.substring(ind1+2);
		}
		return(sPath);
	} catch(Exception ex) {
		System.out.println("Error in reading config");
		return("no path found");
	}
    }
	

    public Layer doParse(String layerid, String servicexml,
		String serviceaxl,String service)
    {
	try {
		//System.out.print("1. Entered doParse for service "+service);
		//System.out.println(" and layerid "+layerid);
		servletXMLParse xp=new servletXMLParse();
		Hashtable axllayers=xp.doParse(serviceaxl,service,"AXL");
		//System.out.println("2. Finished with parsing AXL"+ axllayers.size());
		Hashtable xmllayers=xp.doParse(servicexml,service,"XML");
		//System.out.println("3. Finished with parsing XML "+xmllayers.size());
		Hashtable layers=new Hashtable();
		layers=mergeLayers(xmllayers,axllayers);
		System.out.println("came back with size of layers as : "+layers.size());
		System.out.println("ID considered here:"+layerid);
		Layer layerinfo=(Layer)layers.get(layerid);
		//System.out.println("layer :"+layerinfo.getName()+" has renderer::"+layerinfo.getRendererType());
		return(layerinfo);
	} catch(Exception ex) {
		ex.printStackTrace();
		return(null);
	}
    }

    public Hashtable mergeLayers(Hashtable xmllayers, Hashtable axllayers)
    {
	Hashtable activeServiceLayers=axllayers;
	Hashtable tLayers=xmllayers;
	Hashtable newActiveServiceLayers=axllayers;

	Enumeration tEle=tLayers.keys();
	String lStr;
	Layer l1,l2;
	String val;
	Hashtable flds;
	Object currRndr;
	String currRndrType;
	while(tEle.hasMoreElements()) {
	    lStr=(String)tEle.nextElement();
	    if(activeServiceLayers.containsKey(lStr)) {
		//System.out.println("updating " + lStr+"   ");
		l1=(Layer)activeServiceLayers.get(lStr);
		l2=(Layer)tLayers.get(lStr);
		
		val=l2.getMaxx(); l1.setMaxx(val);
		val=l2.getMaxy(); l1.setMaxy(val);
		val=l2.getMinx(); l1.setMinx(val);
		val=l2.getMiny(); l1.setMiny(val);
		
		flds=l2.getFields(); l1.setFields(flds);
		currRndr=l2.getRenderer();
		l1.setRenderer(currRndr);
		currRndrType=l2.getRendererType();
		l1.setRendererType(currRndrType);
		//System.out.println("set renderertype : "+l1.getRendererType());
		
		//activeServiceLayers.remove(lStr);
		newActiveServiceLayers.put(lStr,l1);
		
		/*l1=(Layer)newActiveServiceLayers.get(lStr);
		flds=l1.getFields();
		System.out.println("Size of fields:"+flds.size());
		System.out.println("");*/
	    }
	}
	
	return(newActiveServiceLayers);
    }

    public Hashtable extractLayer(String layerid, Hashtable layers)
    {
	return(null);
    }
	
    public void updateLayers(Hashtable val) 
    {
	//Enumeration en=layers.	
    }

    public String getLayerAXL(String layerID, String service)
    {
	String xmlReq;
	String xmlResponse;
	try {
		xmlReq=getServiceRequest();
		xmlResponse=sendMapRequest(service,xmlReq);
		System.out.println("Sent request :" + service);
		System.out.println("got back :" + xmlResponse);
		servletXMLParse xp=new servletXMLParse();
		Hashtable lyrs=xp.doParse(xmlResponse,service,"RENDERERS");
		Layer lyr=(Layer)lyrs.get(layerID);
		//System.out.println("layer name here:"+layerID);
		String rendererType=lyr.getRendererType();
		//System.out.println("rendererType here:"+rendererType);
		Hashtable flds=lyr.getFields();
		//System.out.println("flds size:"+flds.size());
		Enumeration en=flds.keys();
		String str=getRendererAXL(lyr)+";;";
		while(en.hasMoreElements()) {
			str+=(String)en.nextElement()+":";
		}
		
		return(str);
	} catch(Exception ex) {
		System.out.println("Exception in getLayerAXL");
		ex.printStackTrace();
		xmlResponse=null;
		return(null);
	}
    }
    
    public String sendMapRequest(String service,String requestXML)
    {
	Maptest mapbean=new Maptest();
	mapbean.setParams("hercules.csee.umbc.edu",5300);
	//System.out.println("Sending to " + service + "\n"+ requestXML);
	mapbean.sendAXLRequest(service,requestXML);
	String responseXML=mapbean.AXLResponse;
	//System.out.println(responseXML);
	return(responseXML);
	
    }
}

