/*  
    This Applet enables the addition of Layers from across different services
    into a single service.  This feature also incorporates the shifting of
    Layers in the z-buffer order andmodification of their renderers.

    Written by : Peter DSouza, pdsouz1@csee.umbc.edu
    Date: 25th March 2002.
*/
import java.io.*;
import java.util.*;
import java.applet.Applet.*;
import javax.swing.JApplet.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.basic.BasicTreeUI;
import java.util.*;
import java.net.*;
import ui.*;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.*;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.InputSource;
import ims.renderers.*;

public class SimpleApplet extends JApplet implements ItemListener{

    //Contains list of parameters from config file
    Hashtable parameters;
    
    //GUI elements
    Container contentPane;
    JPanel cardPanel;
    JPanel treePanel;
    JPanel rendererPanel;
    CardLayout cardLayout;
    JTree oldTree, newTree;
    JPanel oldTreePanel, newTreePanel;
    JScrollPane oldTreeScrollPane, newTreeScrollPane;

    // DOM Parser to build tree
    DOMParser parser;

    JButton modifyButton;
    JButton saveButton;
    
    //Other GUI elements
    DefaultTreeModel oldModel, newModel;
    DefaultTreeModel rendererModel;
    DefaultMutableTreeNode oldRoot, oldCurrent,oldCurrent1;
    DefaultMutableTreeNode newRoot, newCurrent;
    DefaultMutableTreeNode rendererRoot;
    
    //Icons used for tree and buttons
    Icon leafIcon_Orig, collapsedIcon_Orig, expandedIcon_Orig;
    Icon leafIcon_New, collapsedIcon_New, expandedIcon_New;
    Icon leafIcon_Rend, collapsedIcon_Rend, expandedIcon_Rend;
    Icon addIcon, removeIcon, startIcon;
    Icon modifyIcon, updateIcon, cancelIcon;
    Icon deleteIcon;
    Icon helpIcon;

    //Paths of images used
    protected String leafImage_orig;
    protected String iconStr;
    protected String leafImage="images/leaficon.gif";
    protected String collapsedImage="images/aimslogo1x2.gif";
    protected String expandedImage="images/aimslogo1x2.gif";
    protected String addImage="images/add.gif";
    protected String removeImage="images/remove.gif";
    //Service AXL
    String serviceAXL="";
    
    //Still other GUI elements
    JPanel rendererTreePanel;
    JPanel extPanel;
    JScrollPane rendererTreePane;
    JPanel rendererTablePanel;
    JScrollPane rendererTablePane;
    JTree rendererTree;
    DefaultMutableTreeNode currentRenderer;
    JPanel rndrPanel;
    JPanel symbolPanel;
    JPanel fldPanel;
    dialogframe paletteWindow;
    public JButton colorButton;
    JComboBox jcField;
    JComboBox jcAttributes;
    JComboBox jcExtended;
    JTextField jcDefault;
    JTextField attrValue;
    JComboBox jcRenderer;
    JComboBox jcSymbol;
    JComboBox jcColor;

    //Name of current layer selected
    String currLayerSelected="";
    //Renderer type of selected renderer
    String currentRendererType;
    //default colors
    Hashtable defaultColors;
    //Elements for color palette
    public JTextField colorSample;
    JTextField rValue;
    JTextField gValue;
    JTextField bValue;
    JButton updateAttr;
    JButton addRndr; 
    JButton addSymbol; 
    JButton updateField; 
    JButton updateColor;
    JButton addExt;
    JLabel rendPaneTitle;
    
    //toggles visibility of palette
    boolean isPaletteVisible;
    
    //specifies if renderer or color is being updated
    String updateType;
    //current value of renderer attribute
    String currRendererValue;
    //current value of symbol attribute
    String currSymbolValue;
    //current value of symbol field
    String currFieldValue;
    //current value of color
    String currColorValue;
    //current value of attribute
    String currAttrValue;
    //current Attribute selected
    String currAttribute;
    //Font value
    String currFontValue;
    //new renderer xml
    String modifiedRendererXML;

    Hashtable allVals;

   /**
    * initial function.  Draws the initial layout of the applet.
    */
   public void init() {
	String treeAXL=GetMetadata();
	//System.out.println("treeAXL:"+treeAXL);
	treeAXL=extractParameters(treeAXL);
	
	DrawUI();
	
	DrawOldTree(treeAXL);
	
	DrawNewTree();
	
	DrawRendererUI();
	
    }
    
   /**
    * Creates outer container with listeners
    */
    public void DrawUI()
    {
	contentPane=getContentPane();
	contentPane.setLayout(null);

	createIcons();
	
	cardPanel=new JPanel();
	cardLayout=new CardLayout();
	cardPanel.setLayout(cardLayout);
	
	treePanel=new JPanel();
	treePanel.setLayout(null);
	rendererPanel=new JPanel();
	rendererPanel.setLayout(null);

	JButton helpButton=new JButton("Help",helpIcon);
	helpButton.addActionListener(new GlobalListener());
	contentPane.add(helpButton);
	//helpButton.setBackground(Color.black);
	helpButton.setFont(new Font("Serif", Font.BOLD, 9));
	helpButton.setBounds(700,5,100,30);
	
	JButton tree1AddButton=new JButton("Add Layer",addIcon);
	tree1AddButton.addActionListener(new GlobalListener());
	treePanel.add(tree1AddButton);
	tree1AddButton.setBounds(200,245,150,30);

	JButton tree1RemoveButton=new JButton("Remove Layer",removeIcon);
	tree1RemoveButton.addActionListener(new GlobalListener());
	treePanel.add(tree1RemoveButton);
	tree1RemoveButton.setBounds(450,245,150,30);
	
	JButton startButton=new JButton("Start Service",startIcon);
	startButton.addActionListener(new GlobalListener());
	treePanel.add(startButton);
	startButton.setBounds(50,520,150,30);

	JButton moveUpButton=new JButton("Move Up",removeIcon);
	moveUpButton.addActionListener(new GlobalListener());
	treePanel.add(moveUpButton);
	moveUpButton.setBounds(220,520,120,30);

	JButton moveDownButton=new JButton("Move Down",addIcon);
	moveDownButton.addActionListener(new GlobalListener());
	treePanel.add(moveDownButton);
	moveDownButton.setBounds(360,520,130,30);

	modifyButton=new JButton("Modify Renderer",modifyIcon);
	modifyButton.addActionListener(new GlobalListener());
	treePanel.add(modifyButton);
	modifyButton.setBounds(500,520,200,30);
	
	/*saveButton=new JButton("Save Tree",modifyIcon);
	saveButton.addActionListener(new GlobalListener());
	treePanel.add(saveButton);
	saveButton.setBounds(650,520,130,30);*/

	cardPanel.add(treePanel,"TREEPANEL");
	cardPanel.add(rendererPanel,"RENDERERPANEL");
	contentPane.add(cardPanel);
	cardPanel.setBounds(5,50,790,590);
	
	JLabel titleLabel=new JLabel(getParam("MAPTITLE"));
	titleLabel.setFont(new Font("Serif", Font.BOLD, 30));
	contentPane.add(titleLabel);
	titleLabel.setBounds(15,3,500,30);

	JLabel pane1Title=new JLabel(getParam("TITLE_ORIG_PANE"));
	pane1Title.setFont(new Font("Serif", Font.BOLD, 15));
	treePanel.add(pane1Title);
	pane1Title.setBounds(10,1,250,18);

	//System.out.println("Title:"+getParam("TITLE_NEW_PANE"));
	JLabel pane2Title=new JLabel(getParam("TITLE_NEW_PANE"));
	pane2Title.setFont(new Font("Serif", Font.BOLD, 15));
	treePanel.add(pane2Title);
	pane2Title.setBounds(10,258,250,18);
    }

   /**
    * Displays new window containing map of new service
    */
    public void showMap(String serviceName)
    {
	//serviceName="Rasters";
	try {
	getAppletContext().showDocument(new URL("http://hercules.csee.umbc.edu:9780/website/MovingCity/viewer.jsp?serviceName="+serviceName), "_blank"); 
	} catch(Exception ex) {
		System.out.println("Error in opening new window in showMap()");
		ex.printStackTrace();
	}
    }

   /**
    * Displays Help screen
    */
    public void showHelp()
    {
	try {
	getAppletContext().showDocument(new URL("http://hercules.csee.umbc.edu:8099/arcims/newService/hlp.jsp"),"_blank"); 
	} catch(Exception ex) {
		System.out.println("Error in opening Help window");
		ex.printStackTrace();
	}
    }
    
   /**
    * Initializes icons to beused
    */
    public void createIcons()
    {
	URL iconURL;
	URL leafURL,collapsedURL,expandedURL;
	URL helpURL;
	String leafIconStr,collapsedIconStr,expandedIconStr;

	//leafIconStr=getParam("LEAF_ICON_ORIG");
	leafURL=getURL(getParam("LEAF_ICON_ORIG"));
	leafIcon_Orig=new ImageIcon(leafURL,"leaf node");

	//collapsedIconStr=getParam("COLLAPSED_ICON_ORIG");
	collapsedURL=getURL(getParam("COLLAPSED_ICON_ORIG"));
	collapsedIcon_Orig=new ImageIcon(collapsedURL,"collapsed node");

	//expandedIconStr=getParam("EXPANDED_ICON_ORIG");
	expandedURL=getURL(getParam("EXPANDED_ICON_ORIG"));
	expandedIcon_Orig=new ImageIcon(expandedURL,"expanded node");


	//leafIconStr=getParam("LEAF_ICON_ORIG");
	leafURL=getURL(getParam("LEAF_ICON_NEW"));
	leafIcon_New=new ImageIcon(leafURL,"leaf node");

	//leafIconStr=getParam("LEAF_ICON_ORIG");
	helpURL=getURL(getParam("HELP_ICON"));
	helpIcon=new ImageIcon(helpURL,"Help");

	//collapsedIconStr=getParam("COLLAPSED_ICON_NEW");
	collapsedURL=getURL(getParam("COLLAPSED_ICON_NEW"));
	collapsedIcon_New=new ImageIcon(collapsedURL,"collapsed node");

	//expandedIconStr=getParam("EXPANDED_ICON_NEW");
	expandedURL=getURL(getParam("EXPANDED_ICON_NEW"));
	expandedIcon_New=new ImageIcon(expandedURL,"expanded node");

	//leafIconStr=getParam("LEAF_ICON_REND");
	leafURL=getURL(getParam("LEAF_ICON_REND"));
	leafIcon_Rend=new ImageIcon(leafURL,"leaf node");

	//collapsedIconStr=getParam("COLLAPSED_ICON_REND");
	collapsedURL=getURL(getParam("COLLAPSED_ICON_REND"));
	collapsedIcon_Rend=new ImageIcon(collapsedURL,"collapsed node");

	//expandedIconStr=getParam("EXPANDED_ICON_REND");
	expandedURL=getURL(getParam("EXPANDED_ICON_REND"));
	expandedIcon_Rend=new ImageIcon(expandedURL,"expanded node");

	iconURL = getURL(getParam("ADD_BUTTON_ICON"));
	addIcon = new ImageIcon(iconURL,"Add Layer");
	iconURL = getURL(getParam("REMOVE_BUTTON_ICON"));
	removeIcon = new ImageIcon(iconURL,"Remove Layer");
	iconURL = getURL(getParam("START_SERVICE_ICON"));
	startIcon = new ImageIcon(iconURL,"Start Service");
	iconURL = getURL(getParam("MODIFY_REND_ICON"));
	modifyIcon = new ImageIcon(iconURL,"Modify Renderer");
	iconURL = getURL(getParam("UPDATE_REND_ICON"));
	updateIcon = new ImageIcon(iconURL,"Update Renderer");
	iconURL = getURL(getParam("CANCEL_ICON"));
	cancelIcon = new ImageIcon(iconURL,"Cancel Changes");
	iconURL = getURL(getParam("DELETE_ICON"));
	deleteIcon = new ImageIcon(iconURL,"Delete node");

    }
    
   /**
    * Used to draw image.
    */
    protected URL getURL(String filename) {
        URL codeBase = getCodeBase();
        URL url = null;
	
        try {
            url = new URL(codeBase, filename);
        } catch (java.net.MalformedURLException e) {
            System.err.println("Couldn't create image: " +
                               "badly specified URL");
            return null;
        }
	
        return url;
    }

   /**
    * Tokenize parameter string and extract individual parameters
    */
    public String extractParameters(String axl)
    {
	//System.out.println("\nStart of extractParameters"+axl);
	String str=axl.substring(0,axl.indexOf(";;"));
	String paramStr=axl.substring(axl.indexOf(";;")+2);
	parameters=new Hashtable();
	int i,j;
	while((i=paramStr.indexOf("::"))!=-1) {
		j=paramStr.indexOf(":");
		parameters.put(paramStr.substring(0,j),
			paramStr.substring(j+1,i));
		paramStr=paramStr.substring(i+2);
	}
	//System.out.println("Found "+parameters.size()+" parameters");
	//System.out.println("\nEnd of extractParameters");
	return(str);
	
    }
    
    
   /**
    * Draw Original tree
    */
    public void DrawOldTree(String treeAXL)
    {

	StringReader sr=new StringReader(treeAXL);
	try {
	    parser=new DOMParser();
	    Errors errors=new Errors();
	    //parser.setFeature ("http://xml.org/sax/features/validation", true);  
	    parser.setErrorHandler(errors);
	    parser.parse(new InputSource(sr));
	    Document d1=parser.getDocument();
	    oldTree=new DOMTree(d1);
	    oldTreePanel=new JPanel();
	    oldTreePanel.setLayout(new GridLayout(1,1));
	    oldTreePanel.add(oldTree);
	    oldTree.addMouseListener(new MouseAdapter() {
		    public void mouseClicked(MouseEvent me) {
			oldTreeSelect(me);
		    }
		});
	    oldTreeScrollPane=new JScrollPane(oldTreePanel);
	    treePanel.add(oldTreeScrollPane);
	    oldTreeScrollPane.setBounds(5,25,775,215);
	    Color color=getRGB(getParam("BACKGROUNDCOLOR_ORIG"));
	    oldTree.setBackground(color);
	    oldTree.putClientProperty("JTree.lineStyle", "Angled");
	    
	    renderTree(oldTree,
		getParam("SEL_TEXT_ORIG"), getParam("SEL_TEXT_BKG_ORIG"),
		getParam("UNSEL_TEXT_ORIG"),getParam("UNSEL_TEXT_BKG_ORIG"),
		leafIcon_Orig,expandedIcon_Orig,collapsedIcon_Orig);
	    
	    treePanel.repaint();
	    oldModel=(DefaultTreeModel)oldTree.getModel();
	    oldRoot=(DefaultMutableTreeNode)((DefaultMutableTreeNode)oldModel.getRoot()).getFirstChild();
	    RemoveTreeTags(oldRoot);
	    //oldTree.updateUI();
	} catch (Exception ex) {
	    System.out.println("Exception occured while drawing old tree");
	    System.out.println(ex.getMessage());
	}
    }
    
   /**
    * Event fired when node in tree is selected
    */
    public void oldTreeSelect(MouseEvent me)
    { 
	TreePath tp=oldTree.getPathForLocation(me.getX(),me.getY());
        DefaultMutableTreeNode n1;
	String n;
        if(tp!=null) {
	    n1=(DefaultMutableTreeNode)(tp.getLastPathComponent());
	    n=n1.toString();
	    if(!n.equals("MAPS")) {
		if(n1.isLeaf()&&
		   ((DefaultMutableTreeNode)n1.getParent()).toString().indexOf("MAPS")==-1) { 
		    oldCurrent=(DefaultMutableTreeNode)n1.getParent();
		    oldCurrent1=oldCurrent;
		}
		else if(n1.toString().indexOf("RENDERERS")!=-1) {
		}
		else {
		    oldCurrent=n1;
		    oldCurrent1=oldCurrent;
		}
		System.out.println("selected "+oldCurrent.toString()+" in old tree");
	    }
	    else {
		oldCurrent=null;
		oldCurrent1=oldCurrent;
		//System.out.println("set oldCurrent to null");
	    }
        }
	else {
	    oldCurrent=null;
	    oldCurrent1=oldCurrent;
	    //System.out.println("set oldCurrent to null");
	}
    }
    
   /**
    * Draw tree for new service
    */
    public void DrawNewTree()
    {
	String treeAXL="<NEWSERVICE></NEWSERVICE>";
	//System.out.println("treeAXL:"+treeAXL);
	try {
	    StringReader sr=new StringReader(treeAXL);
	    parser=new DOMParser();
	    Errors errors=new Errors();
	    parser.setErrorHandler(errors);
	    parser.parse(new InputSource(sr));
	    Document d1=parser.getDocument();
	    newTree=new DOMTree(d1);
	    newTreePanel=new JPanel();
	    newTreePanel.setLayout(new GridLayout(1,1));
	    newTreePanel.add(newTree);
	    newTree.addMouseListener(new MouseAdapter() {
		    public void mouseClicked(MouseEvent me) {
			newTreeSelect(me);
		    }
		});
	    newTreeScrollPane=new JScrollPane(newTreePanel);
	    treePanel.add(newTreeScrollPane);
	    newTreeScrollPane.setBounds(5,280,780,235);
	    Color color=getRGB(getParam("BACKGROUNDCOLOR_NEW"));
	    newTree.setBackground(color);
	    oldTree.putClientProperty("JTree.lineStyle", "Angled");
	    
	    renderTree(newTree,
		getParam("SEL_TEXT_NEW"), getParam("SEL_TEXT_BKG_NEW"),
		getParam("UNSEL_TEXT_NEW"),getParam("UNSEL_TEXT_BKG_NEW"),
		leafIcon_New,expandedIcon_New,collapsedIcon_New);
	    
	    treePanel.repaint();
	    newModel=(DefaultTreeModel)newTree.getModel();
	    newRoot=(DefaultMutableTreeNode)((DefaultMutableTreeNode)newModel.getRoot()).getFirstChild();
	    RemoveTreeTags(newRoot);
	    newCurrent=null;
	} catch (Exception ex) {
	    System.out.println("Error drawing new tree :"+ex.getMessage());
	}
    }

   /**
    * Get color object corresponding to RGB string
    */
   public Color getRGB(String color)
   {
	int index;
	index=color.indexOf(',');
	String rColor=color.substring(0,index);
	int index1=color.indexOf(',',index+1);
	String gColor=color.substring(index+1,index1);
	String bColor=color.substring(index1+1);
	return(new Color(Integer.parseInt(rColor),Integer.parseInt(gColor),Integer.parseInt(bColor)));
   }

   /**
    * Extract parameter value corresponding to parameter name from hashtable
    */
   public String getParam(String key)
   {
	if(parameters.size()!=0&&parameters.containsKey(key)) {
		return((String)parameters.get(key));
	}
	else return("");
   }

   /**
    * Update renderer string to reflect changes
    */
   public void updateRendererXML()
   {
	serviceAXL="";
	traverse(rendererRoot);
	//System.out.println("serviceAXL:"+serviceAXL);
	StringReader sr=new StringReader(serviceAXL);
	JTree tempTree;
	DefaultTreeModel tempModel;
	DefaultMutableTreeNode tempRoot;
        try {
            parser=new DOMParser();
            Errors errors=new Errors();
            //parser.setFeature ("http://xml.org/sax/features/validation", true)
;
            parser.setErrorHandler(errors);
            parser.parse(new InputSource(sr));
            Document d1=parser.getDocument();
	    tempTree=new DOMTree(d1);
	    tempModel=(DefaultTreeModel)tempTree.getModel();
            tempRoot=(DefaultMutableTreeNode)((DefaultMutableTreeNode)tempModel.getRoot()).getFirstChild();
	    newCurrent.add(tempRoot);
	    RemoveTreeTags(newCurrent);
	 }
	 catch(Exception ex) {
		ex.printStackTrace();
	}

	cardLayout.show(cardPanel,"TREEPANEL");
	serviceAXL="";
   }
    
   /**
    * Draw Renderer screen
    */
    public void DrawRendererUI()
    {
	DrawRendererTree();
	
	DrawRendererTable();
	
 	JButton b1=new JButton("Update Main View",updateIcon);
	b1.addActionListener(new GlobalListener());
	modifiedRendererXML=null;

 	JButton b3=new JButton("Delete Node",deleteIcon);
	b3.addActionListener(new GlobalListener());
	
	JButton b2=new JButton("Cancel",cancelIcon);
	b2.addActionListener(new GlobalListener());
	
	rendererPanel.add(b1);
	b1.setBounds(100,515,200,30);
	rendererPanel.add(b3);
	b3.setBounds(345,515,160,30);
	rendererPanel.add(b2);
	b2.setBounds(550,515,150,30);
	
	paletteWindow=new dialogframe("Palette",this);
	paletteWindow.setSize(400,500);
	paletteWindow.setVisible(false);
	isPaletteVisible=false;
    }

   /**
    * Toggle between cardlayout panels
    */
    public void showTreeUI()
    {
	cardLayout.show(cardPanel,"TREEPANEL");
    }
    
   /**
    * Creates labels for renderer panel
    */
    public void createLabel(String labelText)
    {
	JLabel label1=new JLabel(labelText,JLabel.CENTER);
	label1.setFont(new Font(getParam("RENDERER_LABEL_FONT"), Font.BOLD, (new Integer(getParam("RENDERER_LABEL_SIZE"))).intValue()));
	label1.setForeground(getRGB(getParam("RENDERER_LABEL_COLOR")));
	label1.setBorder(new EtchedBorder(EtchedBorder.RAISED) );
	rendererTablePanel.add(label1);
	//return(label1);
    }

   /**
    * Draws panel for extended elements (EXACT,OTHER,etc)
    */
    public void drawExtUI()
    {
	extPanel=new JPanel();
	extPanel.setLayout(null);
	jcExtended=drawExtendedList();
	extPanel.add(jcExtended);
	jcExtended.setBounds(5,1,200,30);
	addExt=new JButton("Add");
	addExt.setFont (new Font("Helvetica", Font.BOLD, 11));
	addExt.addActionListener(new RendererListener("Extended"));
	extPanel.add(addExt);
	addExt.setBounds(290,1,60,30);
	rendererTablePanel.add(extPanel);
	
    }

   /**
    * Dropdown box for extended elements
    */
    public JComboBox drawExtendedList()
    {
	JComboBox jc=new JComboBox();
        jc.addItem("EXACT");
        jc.addItem("OTHER");
        jc.addItem("RANGE");
	return(jc);
    }

   /**
    * Add new extended element
    */
    public void addExtended()
    {
	DefaultMutableTreeNode t1=new DefaultMutableTreeNode("<"+(String)jcExtended.getSelectedItem()+">");
        currentRenderer.add(t1);
        rendererTree.updateUI();
	renderTree(rendererTree,
		getParam("SEL_TEXT_REND"), getParam("SEL_TEXT_BKG_REND"),
		getParam("UNSEL_TEXT_REND"),getParam("UNSEL_TEXT_BKG_REND"),
		leafIcon_Rend,expandedIcon_Rend,collapsedIcon_Rend);
    }

   /**
    * Draws renderer table
    */
    public void DrawRendererTable()
    {
	rendererTablePanel=new JPanel();
	rendererTablePanel.setLayout(new GridLayout(0,2));
	
	rendererTablePanel.setFont(new Font("Times New Roman", Font.PLAIN, 10));
	
	createLabel("Renderer");
	drawRndrUI();
	
	createLabel("Extended");
	drawExtUI();

	createLabel("Symbol");
	drawSymbolUI();
	
	createLabel("Field");
	drawFldUI();
	
	createLabel("Color");
	drawColorUI();
	
	createLabel("Attributes");
	drawAttrUI();
	currAttribute="";
	
	createLabel("Allowed Values");
	jcDefault=new JTextField();
	jcDefault.setEnabled(false);
	rendererTablePanel.add(jcDefault);
	
	rendererTablePane=new JScrollPane(rendererTablePanel);
	rendererPanel.add(rendererTablePane);
	rendererTablePane.setBounds(5,250,780,260);

	updateType=null;
    }

   /**
    * Draws UI for attributes
    */
    void drawAttrUI()
    {
	JPanel p1=new JPanel();
	p1.setLayout(null);
	jcAttributes=new JComboBox();
	jcAttributes.setEnabled(false);
	p1.add(jcAttributes);
	jcAttributes.setBounds(5,1,150,30);
	JLabel j1=new JLabel("=");
	p1.add(j1);
	j1.setBounds(157,1,10,30);
	attrValue=new JTextField(15);
	attrValue.setEnabled(false);
	p1.add(attrValue);
	attrValue.setBounds(169,1,120,30);
	updateAttr=new JButton("Update");
	updateAttr.setFont (new Font("Helvetica", Font.BOLD, 11));
	updateAttr.addActionListener(new RendererListener("UpdateAttrib"));
	
	p1.add(updateAttr);
	updateAttr.setBounds(291,1,90,30);
	rendererTablePanel.add(p1);
	currAttrValue="";
    }

   /**
    * Draws UI for Renderer
    */
    public void drawRndrUI()
    {
	rndrPanel=new JPanel();
	rndrPanel.setLayout(null);
	jcRenderer=drawRendererList();
	rndrPanel.add(jcRenderer);
	jcRenderer.setBounds(5,1,200,30);
	addRndr=new JButton("Add");
	addRndr.setFont (new Font("Helvetica", Font.BOLD, 11));
	addRndr.addActionListener(new RendererListener("AddRenderer"));
	addRndr.setBounds(290,1,60,30);
	rndrPanel.add(addRndr);
	rendererTablePanel.add(rndrPanel);
    }
    
   /**
    * Draws UI for Symbols
    */
    public void drawSymbolUI()
    {
	symbolPanel=new JPanel();
	symbolPanel.setLayout(null);
	jcSymbol=drawSymbolList();
	symbolPanel.add(jcSymbol);
	jcSymbol.setBounds(5,1,200,30);
	addSymbol=new JButton("Add");
	addSymbol.setFont (new Font("Helvetica", Font.BOLD, 11));
	addSymbol.addActionListener(new RendererListener("AddSymbol"));
	symbolPanel.add(addSymbol);
	addSymbol.setBounds(290,1,60,30);
	rendererTablePanel.add(symbolPanel);
    }
    
   /**
    * Draws UI for Fields
    */
    public void drawFldUI()
    {
	fldPanel=new JPanel();
	fldPanel.setLayout(null);
	jcField=new JComboBox();
	jcField.setEnabled(false);
	fldPanel.add(jcField);
	jcField.setBounds(5,1,200,30);
	updateField=new JButton("Update");
	updateField.setFont (new Font("Helvetica", Font.BOLD, 10));
	updateField.addActionListener(new RendererListener("UpdateField"));
	fldPanel.add(updateField);
	updateField.setBounds(265,1,85,30);
	rendererTablePanel.add(fldPanel);
    }

   /**
    * Draws UI for Colors
    */
    public void drawColorUI()
    {
	JPanel colorPanel=new JPanel();
	colorPanel.setLayout(null);
	jcColor=new JComboBox();
	
	defaultColors=new Hashtable();
	defaultColors.put("BLACK",Color.black);
	defaultColors.put("BLUE",Color.blue);
	defaultColors.put("CYAN",Color.cyan);
	defaultColors.put("DARKGRAY",Color.darkGray);
	defaultColors.put("GRAY",Color.gray);
	defaultColors.put("GREEN",Color.green);
	defaultColors.put("LIGHTGRAY",Color.lightGray);
	defaultColors.put("MAGENTA",Color.magenta);
	defaultColors.put("ORANGE",Color.orange);
	defaultColors.put("PINK",Color.pink);
	defaultColors.put("RED",Color.red);
	defaultColors.put("WHITE",Color.white);
	defaultColors.put("YELLOW",Color.yellow);
	
	Enumeration en=defaultColors.keys();
	while(en.hasMoreElements()) {
	    jcColor.addItem((String)en.nextElement());
	    jcColor.addItemListener(this);
	}
	//jcColor.setEnabled(false);
	colorPanel.add(jcColor);
	jcColor.setBounds(5,1,80,30);
	
	rValue=new JTextField(3);
	//rValue.setEnabled(false);
	colorPanel.add(rValue);
	rValue.setBounds(87,1,40,30);
	gValue=new JTextField(3);
	//gValue.setEnabled(false);
	colorPanel.add(gValue);
	gValue.setBounds(129,1,40,30);
	bValue=new JTextField(3);
	//bValue.setEnabled(false);
	colorPanel.add(bValue);
	bValue.setBounds(171,1,40,30);
	colorSample=new JTextField(2);
	//colorSample.setSize(15,15);
	colorSample.setEnabled(false);
	colorSample.setBackground(Color.green);
	updateRGB(Color.green);
	currColorValue=rValue+","+gValue+","+bValue;
	colorPanel.add(colorSample);
	colorSample.setBounds(213,1,25,30);
	colorButton=new JButton("Palette");
	colorButton.setFont(new Font("Helvetica", Font.BOLD, 11));
	colorButton.addActionListener(new RendererListener("ColorButton"));
	colorPanel.add(colorButton);
	colorButton.setBounds(240,1,80,30);
	updateColor=new JButton("Update");
	updateColor.setFont(new Font("Helvetica", Font.BOLD, 10));
	updateColor.addActionListener(new RendererListener("UpdateColor"));
	
	colorPanel.add(updateColor);
	updateColor.setBounds(322,1,80,30);
	rendererTablePanel.add(colorPanel);
    }
    
   /**
    * Drop down box of renderers
    */
    public JComboBox drawRendererList()
    {
	JComboBox jc=new JComboBox();
	jc.addItem("SIMPLERENDERER");
	jc.addItem("SIMPLELABELRENDERER");
	jc.addItem("VALUEMAPRENDERER");
	jc.addItem("VALUEMAPLABELRENDERER");
	jc.addItem("SCALEDEPENDENTRENDERER");
	jc.addItem("GROUPRENDERER");
        currRendererValue="SIMPLERENDERER";
	return(jc);
    }
    
   /**
    * Drop down box of symbols
    */
    public JComboBox drawSymbolList()
    {
	JComboBox jc=new JComboBox();
	jc.addItem("CALLOUTMARKERSYMBOL");
	jc.addItem("CHARTSYMBOL");
	jc.addItem("GRADIENTFILLSYMBOL");
	jc.addItem("HASHLINESYMBOL");
	jc.addItem("RASTERFILLSYMBOL");
	jc.addItem("RASTERMARKERSYMBOL");
	jc.addItem("RASTERSHIELDSYMBOL");
	jc.addItem("SIMPLELINESYMBOL");
	jc.addItem("SIMPLEMARKERSYMBOL");
	jc.addItem("SIMPLEPOLYGONSYMBOL");
	jc.addItem("SHIELDSYMBOL");
	jc.addItem("TEXTMARKERSYMBOL");
	jc.addItem("TEXTSYMBOL");
	jc.addItem("TRUETYPEMARKERSYMBOL");
        currSymbolValue="CALLOUTMARKERSYMBOL";
	return(jc);
    }
    
   /**
    * Draws final renderer tree
    */
    public void DrawRendererTree()
    {
	
	String rendererString;
	rendererString="<RENDERER></RENDERER>";
	StringReader sr=new StringReader(rendererString);
	try {
	    rendererTreePanel=new JPanel();
	    rendererTreePanel.setLayout(new GridLayout(1,1));
	    rendererTreePane=new JScrollPane(rendererTreePanel);
	    rendererPanel.add(rendererTreePane);
	    //rendererTreePane.setBounds(5,5,780,235);
	    rendererTreePane.setBounds(5,25,780,215);

		rendPaneTitle=new JLabel(getParam("TITLE_REND_PANE")+" "+currLayerSelected);
		rendPaneTitle.setFont(new Font("Serif", Font.BOLD, 15));
		rendererPanel.add(rendPaneTitle);
		rendPaneTitle.setBounds(10,1,550,18);
	    
	    /*rendererTree.setBackground(new Color(120,175,225));
	    rendererTree.putClientProperty("JTree.lineStyle", "Angled");*/
	} catch(Exception ex) {
	    ex.printStackTrace();
	}
    }
    
   /**
    * event fired when node in renderer tree is selected
    */
    public void rendererTreeSelect(MouseEvent me)
    {
	TreePath tp=rendererTree.getPathForLocation(me.getX(),me.getY());
        DefaultMutableTreeNode n1;
        if(tp!=null) {
	    n1=(DefaultMutableTreeNode)(tp.getLastPathComponent());
	    currentRenderer=n1;
	    currentRendererType=getRendererType(n1.toString());
	    updateVisFields();
	    updateAttr();
        }
	else {
	    n1=null;
	}
    }

   /**
    * Deletes node from renderer tree
    */
    public void deleteRendererNode()
    {
	rendererModel.removeNodeFromParent(currentRenderer);
	rendererTree.updateUI();
	renderTree(rendererTree,
		getParam("SEL_TEXT_REND"), getParam("SEL_TEXT_BKG_REND"),
		getParam("UNSEL_TEXT_REND"),getParam("UNSEL_TEXT_BKG_REND"),
		leafIcon_Rend,expandedIcon_Rend,collapsedIcon_Rend);

    }

   /**
    * Update attribute with new value
    */
    public void updateAttr()
    {
	Hashtable attrs=new Hashtable();
	allVals=new Hashtable();
	if(!currentRendererType.equals("RENDERERS")) {
	if(currentRendererType.equals("SCALEDEPENDENTRENDERER")) {
		ScaleDependentRenderer rndr=new ScaleDependentRenderer("","");
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("SIMPLELABELRENDERER")) {
		SimpleLabelRenderer rndr=new SimpleLabelRenderer("",null,null,null,null,null,null,null);
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
		//System.out.println("Size of allVals for SIMPLELABELRENDERER:"+allVals.size());
	}
	if(currentRendererType.equals("VALUEMAPRENDERER")) {
		ValueMapRenderer rndr=new ValueMapRenderer("");
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("VALUEMAPLABELRENDERER")) {
		ValueMapLabelRenderer rndr=new ValueMapLabelRenderer("","","",
			"","","","","","");
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("EXACT")) {
		Exact rndr=new Exact("","","");
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("RANGE")) {
		Range rndr=new Range("","","","");
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("OTHER")) {
		Other rndr=new Other("");
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("CALLOUTMARKERSYMBOL")) {
		CalloutMarkerSymbol rndr=new CalloutMarkerSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("CHARTSYMBOL")) {
		ChartSymbol rndr=new ChartSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("GRADIENTFILLSYMBOL")) {
		GradientFillSymbol rndr=new GradientFillSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("HASHLINESYMBOL")) {
		HashlineSymbol rndr=new HashlineSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("RASTERFILLSYMBOL")) {
		RasterFillSymbol rndr=new RasterFillSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("RASTERMARKERSYMBOL")) {
		RasterMarkerSymbol rndr=new RasterMarkerSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("RASTERSHIELDSYMBOL")) {
		RasterShieldSymbol rndr=new RasterShieldSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("SIMPLELINESYMBOL")) {
		SimpleLineSymbol rndr=new SimpleLineSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("SIMPLEMARKERSYMBOL")) {
		SimpleMarkerSymbol rndr=new SimpleMarkerSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("SIMPLEPOLYGONSYMBOL")) {
		SimplePolygonSymbol rndr=new SimplePolygonSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("SHIELDSYMBOL")) {
		ShieldSymbol rndr=new ShieldSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("TEXTMARKERSYMBOL")) {
		TextMarkerSymbol rndr=new TextMarkerSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("TEXTSYMBOL")) {
		TextSymbol rndr=new TextSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
	if(currentRendererType.equals("TRUETYPEMARKERSYMBOL")) {
		TrueTypeMarkerSymbol rndr=new TrueTypeMarkerSymbol();
		attrs=rndr.getAttributes();
		allVals=rndr.getAllowedValues();
	}
		
	}
	if(attrs!=null && attrs.size()!=0) {
		Enumeration en=attrs.elements();
		jcAttributes.removeAllItems();
		while(en.hasMoreElements())
		{
			jcAttributes.addItem((String)en.nextElement());	
			jcAttributes.addItemListener(this);
		}
		jcAttributes.updateUI();
		setValueField((String)jcAttributes.getItemAt(0));
	}
	String att=(String)jcAttributes.getSelectedItem();
	if(allVals.size()!=0&&allVals.containsKey(att)) {
		String allVal=(String)allVals.get(att);
		jcDefault.setText(allVal);
		jcDefault.updateUI();
	}
    }
    
   /**
    * returns type of renderer
    */
    public String getRendererType(String str)
    {
	if(str.indexOf(' ')!=-1) {
	    return(str.substring(1,str.indexOf(' ')));
   	}
	else
	    return(str.substring(1,str.indexOf('>')));
    }
    
   /**
    * Returns true if renderer element is of type RANGE, OTHER or EXACT
    */
    public boolean isExtended(String rndrType)
    {
	if(rndrType.equals("RANGE") || rndrType.equals("EXACT") || 
		rndrType.equals("OTHER")) 
		return(true);
	else
		return(false);
    }

   /**
    * Enables color
    */
    public void setColorEnabled(boolean value)
    {
	rValue.setEnabled(value);
	gValue.setEnabled(value);
	bValue.setEnabled(value);
	colorButton.setEnabled(value);
	colorSample.setEnabled(value);
	jcColor.setEnabled(value);
	updateColor.setEnabled(value);
    }

   /**
    * Enables attribute element
    */
    public void setAttrEnabled(boolean value)
    {
    	jcAttributes.setEnabled(value);
    	attrValue.setEnabled(value);
	updateAttr.setEnabled(value);
    }

   /**
    * Enables all elements
    */
    public void setAllEnabled(boolean value)
    {
	    setColorEnabled(value);
	    jcField.setEnabled(value);
	    updateField.setEnabled(value);
	    jcRenderer.setEnabled(value);
	     addRndr.setEnabled(value);
	    addSymbol.setEnabled(value);
	    jcSymbol.setEnabled(value);
	    setAttrEnabled(value);
	   jcExtended.setEnabled(value);
	   addExt.setEnabled(value);
	   showSymbols("ALL");
   }


   /**
    * Updates visibility of all fields
    */
    public void updateVisFields()
    {
	//System.out.println("Currently chosen :"+currentRendererType);
	setAllEnabled(false);
	String ctype=currentRendererType;
	DefaultMutableTreeNode cRend=currentRenderer;
	String cParent;
	if(cRend!=null)
	      cParent=((DefaultMutableTreeNode)currentRenderer.getParent()).toString();
	else cParent="<RENDERERS>";
	
	//For renderer
	if(ctype.equals("GROUPRENDERER")||ctype.equals("SCALEDEPENDENTRENDERER")) {
		addRndr.setEnabled(true);
		jcRenderer.setEnabled(true);
	}
	//For extended
	if(ctype.equals("VALUEMAPRENDERER")||ctype.equals("VALUEMAPLABELRENDERER")) {
		addExt.setEnabled(true);
		jcExtended.setEnabled(true);
	}
	//For symbol
	if(isExtended(ctype)&&cParent.indexOf("VALUEMAPLABELRENDERER")!=-1) {
		showSymbols("VALUEMAPLABELRENDERER");
	jcSymbol.setEnabled(true);
	addSymbol.setEnabled(true);
	} 
	else if(isExtended(ctype)&&cParent.indexOf("VALUEMAPRENDERER")!=-1) {
		showSymbols("VALUEMAPRENDERER");
	jcSymbol.setEnabled(true);
	addSymbol.setEnabled(true);
	}
	else if(ctype.equals("SIMPLELABELRENDERER")) {
		showSymbols("VALUEMAPLABELRENDERER");
	jcSymbol.setEnabled(true);
	addSymbol.setEnabled(true);
	}
	else if(ctype.equals("SIMPLERENDERER")) {
		showSymbols("VALUEMAPRENDERER");
	jcSymbol.setEnabled(true);
	addSymbol.setEnabled(true);
	}
	//For field
	if(ctype.equals("SIMPLELABELRENDERER")||
	   ctype.equals("VALUEMAPRENDERER") ||
	   ctype.equals("VALUEMAPLABELRENDERER")) {
		jcField.setEnabled(true);
		updateField.setEnabled(true);
	}
	//For color
	if(ctype.indexOf("SYMBOL")!=-1) {
		setColorEnabled(true);
	}
	//For attributes
	if(!ctype.equals("GROUPRENDERER") && 
		!ctype.equals("SCALEDEPENDENTRENDERER")) {
		setAttrEnabled(true);
	}
    }

   /**
    * show symbol list
    */
    public void showSymbols(String ctype)
    {
	jcSymbol.removeAllItems();
	if(ctype.equals("ALL") || ctype.equals("VALUEMAPLABELRENDERER")) {
		jcSymbol.addItem("CALLOUTMARKERSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("CHARTSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("RASTERSHIELDSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("SHIELDSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("TEXTSYMBOL");
		jcSymbol.addItemListener(this);
	}
	if(ctype.equals("ALL") || ctype.equals("VALUEMAPRENDERER")) {
		jcSymbol.addItem("GRADIENTFILLSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("HASHLINESYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("RASTERFILLSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("RASTERMARKERSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("SIMPLELINESYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("SIMPLEMARKERSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("SIMPLEPOLYGONSYMBOL");
		jcSymbol.addItemListener(this);
		jcSymbol.addItem("TRUETYPEMARKERSYMBOL");
		jcSymbol.addItemListener(this);
	}
	jcSymbol.updateUI();
    }

   /**
    * Event fired when new node is selected
    */
    public void newTreeSelect(MouseEvent me)
    {
	TreePath tp=newTree.getPathForLocation(me.getX(),me.getY());
        DefaultMutableTreeNode n1;
        if(tp!=null) {
	    n1=(DefaultMutableTreeNode)(tp.getLastPathComponent());
	    if(n1.toString().indexOf("SERVICE")==-1) {
		newCurrent=n1;
		currLayerSelected=n1.toString();
	    }
	    else {
		newCurrent=null;
	    }
        }
	else {
	    newCurrent=null;
	}
	
    }
    
   /**
    * Starts the actual new service
    */
    public void startService()
    {
	String str="";
	String msg;
	serviceAXL="";
	System.out.println("Starting new Service");
	AddTreeTags(newRoot);
	System.out.println("After Add Tree Tags");
        traverse(newRoot);
	System.out.println("After traverse XML from tree is : " + serviceAXL);
	System.out.println("After removetags");
	str=postRequest(null,serviceAXL,"STARTSERVICE");
	//System.out.println("Service started: got back"+str);
	RemoveTreeTags(newRoot);
	if(str.indexOf("ERROR")==-1)
	{
		showMap(str);
		//msg="Service " + str+" was started successfully";
	}
	else {
		msg="ERROR: Service could not be started";
		resultframe r1=new resultframe(msg);
		r1.setSize(500,200);
		r1.setVisible(true);
	}
	
    }
    
   /**
    * obtains layer ID from layer String
    */
    public String extractLayerID(String layerString)
    {
	int ind;
	if((ind=layerString.indexOf("<ID"))!=-1)
	{
		String str=layerString.substring(ind);
		int ind1=str.indexOf("value")+7;
		String str1=str.substring(ind1,str.indexOf('"',ind1));
		return(str1);
	}
	else return(null);
    }

   /**
    * obtains service name from layer String
    */
    public String extractService(String layerString)
    {
	int ind;
	if((ind=layerString.indexOf("<SERVICE"))!=-1)
	{
		String str=layerString.substring(ind+8);
		int ind1=str.indexOf("id=")+4;
		String str1=str.substring(ind1,str.indexOf('"',ind1));
		return(str1);
	}
	else return(null);
    }

   /**
    * Makes renderer string safe
    */
    public void modifyRenderer()
    {
	
	try {
		//str=postRequest(null,"GETRENDERERINFO");
		serviceAXL="";
		currLayerSelected=currLayerSelected.replace('<',' ');
		currLayerSelected=currLayerSelected.replace('>',' ');
		currLayerSelected=currLayerSelected.trim();
		System.out.println("in modify Renderer:"+currLayerSelected);
		rendPaneTitle.setText(getParam("TITLE_REND_PANE")+" "+currLayerSelected);
		rendPaneTitle.updateUI();
		//System.out.println("new Current here is :"+newCurrent.toString());
		AddTreeTags(newCurrent);
		traverse(newCurrent);
		RemoveTreeTags(newCurrent);
		String lID=extractLayerID(serviceAXL);
		String srvc=extractService(serviceAXL);
		//System.out.println("layerID extracted:"+lID);
		//System.out.println("serviceID:"+srvc);
		String str=postRequest(srvc,lID,"GETRENDERERINFO");
		System.out.println("rendererString:"+str);
		String rendererString="<RENDERERS>"+str.substring(0,str.indexOf(";;"))+"</RENDERERS>";
		String fieldString=str.substring(str.indexOf(";;")+2);
		StringReader sr=new StringReader(rendererString);
		//System.out.println("Done with parsing");
		    parser=new DOMParser();
		    Errors errors=new Errors();
		    parser.setErrorHandler(errors);
		    parser.parse(new InputSource(sr));
		    Document d1=parser.getDocument();
		    rendererTree=new DOMTree(d1);
		//System.out.println("Done with drawing tree");
		    
		    rendererTreePanel.removeAll();
		    rendererTreePanel.add(rendererTree);
		    rendererTree.addMouseListener(new MouseAdapter() {
			    public void mouseClicked(MouseEvent me) {
				rendererTreeSelect(me);
			    }
			});
		    
		    Color color=getRGB(getParam("BACKGROUNDCOLOR_REND"));
		    rendererTree.setBackground(color);
		    rendererTree.putClientProperty("JTree.lineStyle", "Angled");
		    renderTree(rendererTree,
		getParam("SEL_TEXT_REND"), getParam("SEL_TEXT_BKG_REND"),
		getParam("UNSEL_TEXT_REND"),getParam("UNSEL_TEXT_BKG_REND"),
			leafIcon_Rend,expandedIcon_Rend,collapsedIcon_Rend);
		    rendererTreePanel.repaint();
	    rendererModel=(DefaultTreeModel)rendererTree.getModel();
	    rendererRoot=(DefaultMutableTreeNode)((DefaultMutableTreeNode)rendererModel.getRoot()).getFirstChild();
		//System.out.println("Done with rendering tree");

			String fld;
		    while(fieldString.indexOf(':')!=-1) {
			fld=fieldString.substring(0,
				fieldString.indexOf(':'));
			fieldString=fieldString.substring(fieldString.indexOf(':')+1);

			jcField.addItem(fld);
			jcField.addItemListener(this);
		    }
		//System.out.println("Done with adding  fields");
		serviceAXL="";
		currentRendererType="RENDERERS";
		updateVisFields();
	} catch(Exception ex) {
		System.out.println("Error in drawing new renderer tree");
		ex.printStackTrace();
	}
	cardLayout.show(cardPanel,"RENDERERPANEL");
	//str=postRequest(null,null,"GETMETADATA");
    }
    
   /**
    * posts request to fetch data about applet
    */
    public String GetMetadata()
    {
	String str="";
	str=postRequest(null,null,"GETMETADATA");
	return(str);
    }
    
   /**
    * posts request to servlet
    */
    public String postRequest(String service, String request, String cmd)
    {
	URL url;
        URLConnection urlConn;
        DataOutputStream printout;
	DataInputStream readin;
	String value="";
	String content="";
	
	try {
	    url=new URL("http://hercules.csee.umbc.edu:8099/servlet/SimpleServlet");
            urlConn=url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            //urlConn.setRequestProperty("Content-Type","application/octet-stream");
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
	    
            if(request!=null)
                content="request="+URLEncoder.encode (request)+"&";
            if(service!=null)
                content+="service="+URLEncoder.encode (service)+"&";
            if(cmd!=null)
                content+="&cmd="+URLEncoder.encode (cmd);
	    printout=new DataOutputStream(urlConn.getOutputStream());
            printout.writeBytes(content);
            printout.flush();
            printout.close();
	    
            readin=new DataInputStream(urlConn.getInputStream());
            //String val1=(String)input.readObject();
            String str;
            while((str=readin.readLine())!=null)
                value+=str;
            readin.close();
            urlConn=null;
	    //System.out.println("Got back from server :");
	    //System.out.println(value);
            return(value);
	} catch(Exception ex) {
	    ex.printStackTrace();
	    System.out.println("Error in postRequest");
	    return(null);
	}
    }

   /**
    * Creates new node for tree
    */
    public DefaultMutableTreeNode createNewNode(DefaultMutableTreeNode n)
    {
	serviceAXL="";
	AddTreeTags(n);
	traverse(n);
	RemoveTreeTags(n);
	//System.out.println("in createNewNode : "+serviceAXL);
	StringReader sr=new StringReader(serviceAXL);
	try{
		parser=new DOMParser();
		Errors errors=new Errors();
		parser.setErrorHandler(errors);
		parser.parse(new InputSource(sr));
		Document d1=parser.getDocument();
		JTree tempTree=new DOMTree(d1);
		DefaultTreeModel tempModel=(DefaultTreeModel)tempTree.getModel();
		return((DefaultMutableTreeNode)((DefaultMutableTreeNode)tempModel.getRoot()).getFirstChild());
	} catch(Exception ex) {
		ex.printStackTrace();
		return(null);
	}
    }

   /**
    * check if node exists as child
    */
    public boolean existsNode(DefaultMutableTreeNode n3) 
    {
	DefaultMutableTreeNode n4;
	boolean flg=false;
	int cnt=newRoot.getChildCount();
	//System.out.println("Checking for:"+n3.toString());
	//System.out.println("newRoot has children:"+cnt);
	for(int i=0; i<cnt;i++) {
		n4=(DefaultMutableTreeNode)newRoot.getChildAt(i);
		//System.out.println("checking "+n4.toString()+" with "+n3.toString());
		if(n4.toString().equals(n3.toString())) {
			//System.out.println("found at "+i);
			
			flg=true;break;
		}
	}
	//System.out.println("Returning : "+ flg);
	return(flg);
    }
    
    //  ALL EVENT HANDLERS GO HERE
    /**
     * Addition of new node to tree
     **/
    public void tree1Add(DefaultMutableTreeNode n0)
    {
	if(n0!=null) {
		if(n0.toString().indexOf("LAYERGROUP")!=-1) {
			DefaultMutableTreeNode n1;

			int cnt=n0.getChildCount();
			for(int i=0;i<cnt;i++) {
				System.out.println("child at:"+i+":"+n0.getChildAt(i).toString());
				n1=(DefaultMutableTreeNode)n0.getChildAt(i);
				if(n1.toString().indexOf("LAYERGROUP")!=-1) {
					System.out.println("\tLAYERGROUP:"+n1.toString());
					tree1Add(n1);
				}
				else if(n1.toString().indexOf("LAYER")!=-1){
					System.out.println("\tLAYER:"+n1.toString());
					DefaultMutableTreeNode n2=createNewNode(n1);
					RemoveTreeTags(n2);
					if(!existsNode(n1)) {
						newModel.insertNodeInto(n2,newRoot,newRoot.getChildCount());
					}
				}
			}
		}
		else if(n0.toString().indexOf("LAYER")!=-1){
			System.out.println("node :"+n0.toString());
			DefaultMutableTreeNode n2=createNewNode(n0);
			RemoveTreeTags(n2);
			if(!existsNode(n0)) {
				newModel.insertNodeInto(n2,newRoot,newRoot.getChildCount());
			}
		}
		else if(n0.toString().indexOf("MAPS")!=-1){
			System.out.println("node :"+n0.toString());
			for(int i=0;i<n0.getChildCount();i++) {
				tree1Add((DefaultMutableTreeNode)n0.getChildAt(i));
			}
		}
	}
	
    }

    /*public void tree1Add()
    {
	if(oldCurrent!=null) {
	    if(oldCurrent.toString().indexOf("LAYERGROUP")!=-1) {
		DefaultMutableTreeNode n1;
		//System.out.println("children of "+oldCurrent.toString()+":"+oldCurrent.getChildCount());
		int cnt=oldCurrent.getChildCount();
		for(int i=0;i<cnt;i++) {
		    	n1=(DefaultMutableTreeNode)oldCurrent.getChildAt(i);
			if(n1.toString().indexOf("LAYERGROUP")==-1&&n1.toString().indexOf("LAYER")!=-1) {
				////System.out.println("Adding "+n1.toString());
				DefaultMutableTreeNode n2=createNewNode(n1);
				RemoveTreeTags(n2);
				if(!existsNode(n1)) {
					newModel.insertNodeInto(n2,newRoot,newRoot.getChildCount());
				}
			}
			else if(n1.toString().indexOf("LAYERGROUP")!=-1){
				oldCurrent=n1;
				//System.out.println("Old Current here:"+oldCurrent.toString());
				tree1Add();
			}
		}
	    }
	    else if(oldCurrent.toString().indexOf("MAPS")==-1) {
		DefaultMutableTreeNode n2=createNewNode(oldCurrent);
			RemoveTreeTags(n2);
		//newModel.insertNodeInto(n2,newRoot,newRoot.getChildCount());
			if(!existsNode(oldCurrent)) {
		    		newModel.insertNodeInto(n2,newRoot,newRoot.getChildCount());
			}
	    }
	    //***oldTree.updateUI();
	    //***renderTree(oldTree,
		//***getParam("SEL_TEXT_ORIG"), getParam("SEL_TEXT_BKG_ORIG"),
		//***getParam("UNSEL_TEXT_ORIG"),getParam("UNSEL_TEXT_BKG_ORIG"),
		//***leafIcon_Orig,expandedIcon_Orig,collapsedIcon_Orig);
	    renderTree(newTree,
		getParam("SEL_TEXT_NEW"), getParam("SEL_TEXT_BKG_NEW"),
		getParam("UNSEL_TEXT_NEW"),getParam("UNSEL_TEXT_BKG_NEW"),
		leafIcon_New,expandedIcon_New,collapsedIcon_New);
	    //treePanel.repaint();
	}
    }*/
    
   /**
    * Renders tree according to config parameters
    */
    public void renderTree(JTree tree, Icon leafIcon, Icon expandedIcon, Icon collapsedIcon)
    {
	//System.out.println("Rendering tree");
	DefaultTreeCellRenderer tcr =
                (DefaultTreeCellRenderer)tree.getCellRenderer();
	tcr.setTextSelectionColor(Color.white);
	tcr.setTextNonSelectionColor(Color.blue);
	tcr.setBackgroundSelectionColor(Color.blue);
	tcr.setBackgroundNonSelectionColor(Color.white);
	tcr.setOpenIcon(expandedIcon);
	tcr.setClosedIcon(collapsedIcon);
	tcr.setLeafIcon(leafIcon);
	    
	BasicTreeUI basicTreeUI = (BasicTreeUI)tree.getUI();
	basicTreeUI.setExpandedIcon(null);
	basicTreeUI.setCollapsedIcon(null);

    }
    
   /**
    * Renders tree according to config parameters
    */
    public void renderTree(JTree tree,String selectColor,String selectBkg,
	String unselectColor,String unselectBkg,Icon lIcon,
	Icon openIcon, Icon closedIcon)
    {
	DefaultTreeCellRenderer tcr =
                (DefaultTreeCellRenderer)tree.getCellRenderer();
	
	Color color=getRGB(selectColor);
	tcr.setTextSelectionColor(color);

	color=getRGB(unselectColor);
	tcr.setTextNonSelectionColor(color);

	color=getRGB(selectBkg);
	tcr.setBackgroundSelectionColor(color);

	color=getRGB(unselectBkg);
	tcr.setBackgroundNonSelectionColor(color);

	tcr.setOpenIcon(openIcon);

	tcr.setClosedIcon(closedIcon);

	tcr.setLeafIcon(lIcon);
	    
	BasicTreeUI basicTreeUI = (BasicTreeUI)tree.getUI();
	basicTreeUI.setExpandedIcon(null);
	basicTreeUI.setCollapsedIcon(null);
    }
    /**
     * Function executed when node is to beremoved from tree
     **/
    public void tree1Remove()
    {
	if(newCurrent!=null) {
	    newModel.removeNodeFromParent(newCurrent);
	    newTree.updateUI();
	    renderTree(newTree,
		getParam("SEL_TEXT_NEW"), getParam("SEL_TEXT_BKG_NEW"),
		getParam("UNSEL_TEXT_NEW"),getParam("UNSEL_TEXT_BKG_NEW"),
		leafIcon_Orig,expandedIcon_Orig,collapsedIcon_Orig);
	}
    }

    /**
     * Function to update attributes
     **/
    public void updateAttrib()
    {
	String currAXL=currentRenderer.toString();
	//System.out.println("updateAttrib called");
	String attr=(String)jcAttributes.getSelectedItem();
	String val=attrValue.getText();
	int ind1=currAXL.indexOf(attr);
	if(ind1!=-1) {
		int ind2=currAXL.indexOf('"',ind1+attr.length()+2);
		String str=currAXL.substring(ind2);
		currAXL=currAXL.substring(0,ind1+attr.length()+2)+val+currAXL.substring(ind2);
	}
	else {
		int ind2=currAXL.indexOf(">");
		currAXL=currAXL.substring(0,ind2)+" "+attr+"=\""+val+"\">";
	}
	//System.out.println("updating to "+currAXL);
	refreshTree(currAXL);
    }
    
    /**
     * Function to add renderer
     **/
    public void addRndrer()
    {
	//System.out.println("updateRndrer called");
	DefaultMutableTreeNode t1=new DefaultMutableTreeNode("<"+(String)jcRenderer.getSelectedItem()+">");
	currentRenderer.add(t1);
	rendererTree.updateUI();
	renderTree(rendererTree,
		getParam("SEL_TEXT_REND"), getParam("SEL_TEXT_BKG_REND"),
		getParam("UNSEL_TEXT_REND"),getParam("UNSEL_TEXT_BKG_REND"),
		leafIcon_Orig,expandedIcon_Orig,collapsedIcon_Orig);
    }
    
    /**
     * Function to add symbols
     **/
    public void addSymbols()
    {
	//System.out.println("updateSymbols called");
	DefaultMutableTreeNode t1=new DefaultMutableTreeNode("<"+(String)jcSymbol.getSelectedItem()+">");
	currentRenderer.add(t1);
	rendererTree.updateUI();
	renderTree(rendererTree,
		getParam("SEL_TEXT_REND"), getParam("SEL_TEXT_BKG_REND"),
		getParam("UNSEL_TEXT_REND"),getParam("UNSEL_TEXT_BKG_REND"),
		leafIcon_Orig,expandedIcon_Orig,collapsedIcon_Orig);
    }
    
    /**
     * Function to update field with entered value
     **/
    public void updateFld()
    {
	//System.out.println("updateFld called");
	String attr="";
	if(currentRendererType.equals("VALUEMAPLABELRENDERER")||
		currentRendererType.equals("VALUEMAPRENDERER"))
		attr="lookupfield";
	if(currentRendererType.equals("SIMPLELABELRENDERER"))
		attr="field";
	String currAXL=currentRenderer.toString();
	//System.out.println("updateAttrib called");
	String val=(String)jcField.getSelectedItem();
	int ind1=currAXL.indexOf(attr);
	if(ind1!=-1) {
		int ind2=currAXL.indexOf('"',ind1+attr.length()+2);
		String str=currAXL.substring(ind2);
		currAXL=currAXL.substring(0,ind1+attr.length()+2)+val+currAXL.substring(ind2);
	}
	else {
		int ind2=currAXL.indexOf(">");
		currAXL=currAXL.substring(0,ind2)+" "+attr+"=\""+val+"\">";
	}
	//System.out.println("updating to "+currAXL);
	refreshTree(currAXL);
    }
    
    /**
     * Function to update color with entered value
     **/
    public void updColor()
    {
	//System.out.println("updColor called");
	attrValue.setText(rValue.getText()+","+gValue.getText()+","+bValue.getText());
	attrValue.updateUI();
	
    }
    
    
    //  END OF EVENT HANDLERS
    
    /**
     * Function to update color with entered value
     **/
    public void updateRGB(Color col)
    {
	float[] rgbVal=new float[10];
	rValue.setText(""+col.getRed()); rValue.updateUI();
	gValue.setText(""+col.getGreen()); gValue.updateUI();
	bValue.setText(""+col.getBlue()); bValue.updateUI();
    }
    
    class Errors implements ErrorHandler {
        public void warning(SAXParseException ex) {
            System.err.println(ex);
        }
        public void error(SAXParseException ex) {
            System.err.println(ex);
        }
        public void fatalError(SAXParseException ex) {
            System.err.println(ex);
        }
    }

    /**
     * Refreshes renderer tree view
     **/
    public void refreshTree(String str)
    {
	currentRenderer.setUserObject(str);
	rendererTree.updateUI();
	renderTree(rendererTree,
		getParam("SEL_TEXT_REND"), getParam("SEL_TEXT_BKG_REND"),
		getParam("UNSEL_TEXT_REND"),getParam("UNSEL_TEXT_BKG_REND"),
		leafIcon_Orig,expandedIcon_Orig,collapsedIcon_Orig);
    }

    /**
     * Strip nodes of '<' sign
     */
    private void RemoveTreeTags (DefaultMutableTreeNode node) {
	String nodeText=node.toString().replace('<',' ');
	nodeText=nodeText.replace('>',' ');
	node.setUserObject(nodeText);
	//node.updateUI();
	if( !node.isLeaf() ) {
	    Enumeration en=node.children();
	    while(en.hasMoreElements()) {
		RemoveTreeTags((DefaultMutableTreeNode)en.nextElement());
	    }
	}
    }
    /**
     * Adds '<' tags to all nodes
     */
    private void AddTreeTags (DefaultMutableTreeNode node) {
	String nodeText=node.toString();
	System.out.println("oarent here:"+node.getParent().toString());
	//if(node.getParent().toString()==null) System.out.println("parent is null");
	if(node.getParent().toString()!=null) {
	if(node.getParent().toString().equals("<DESCRIPTION>"))
		nodeText=nodeText;
	else
		nodeText="<"+nodeText.trim()+">";
	}
	else
		nodeText="<"+nodeText.trim()+">";
	//System.out.println("nodeTExt:**"+nodeText+"**");
	node.setUserObject(nodeText);
	//node.updateUI();
	if(node.getParent().toString()!=null) {
	if( !node.isLeaf() &&(!node.getParent().toString().equals("<DESCRIPTION>"))) {
	    Enumeration en=node.children();
	    while(en.hasMoreElements()) {
		AddTreeTags((DefaultMutableTreeNode)en.nextElement());
	    }
	}}
	else {
	if( !node.isLeaf() ) {
	    Enumeration en=node.children();
	    while(en.hasMoreElements()) {
		AddTreeTags((DefaultMutableTreeNode)en.nextElement());
	    }
	}}
    }
    /**
     * Create xml representation of tree by recurseive traversal
     **/
    private void traverse (DefaultMutableTreeNode node) {
	int isCharData;
	String nodeText=node.toString();
	if(nodeText.indexOf('<')!=-1) isCharData=0;
	else isCharData=1;
	nodeText=nodeText.replace('<',' ');
	nodeText=nodeText.replace('>',' ');
	nodeText=nodeText.trim();
	if( !node.isLeaf() ) {
	    serviceAXL+="<"+nodeText+">";
	    Enumeration en=node.children();
	    //int size = nl.getLength();
	    while(en.hasMoreElements()) {
		traverse((DefaultMutableTreeNode)en.nextElement());
	    }
	    String closeText;
	    if(nodeText.indexOf(' ') !=-1)
	    	closeText=nodeText.substring(0,nodeText.indexOf(' '));
	    else
	    	closeText=nodeText;
	    serviceAXL+="</"+closeText+">";
	}
	else {
	    if(isCharData==0)
	    	serviceAXL+="<"+nodeText+"/>";
	    else
	    	serviceAXL+=nodeText;
	}
    }

    /**
     * Event fired when item value is changed
     **/
    public void itemStateChanged(ItemEvent ie) {
	if(ie.getSource()==jcColor) {
		String col=(String)ie.getItem();
		Color c1=(Color)defaultColors.get(col);
		colorSample.setBackground(c1);
		colorSample.updateUI();
		updateRGB(c1);
	}
	else if(ie.getSource()==jcAttributes) {
		String str=(String)jcAttributes.getSelectedItem();
		if(str!=null&&allVals.size()!=0&&allVals.containsKey(str)) {
			String allVal=(String)allVals.get(str);
			setValueField(str);
			jcDefault.setText(allVal);
			jcDefault.repaint();
			//System.out.println("redrawing :"+allVal);
		}
	}
    }

    /**
     * sets value of attribute field
     **/
    public void setValueField(String str)
    {
	String str1=currentRenderer.toString();
	int ind1;
	if(str1.indexOf(str)!=-1) {
		ind1=str1.indexOf(str)+str.length()+2;
		String str2=str1.substring(ind1,str1.indexOf('"',ind1));
		//System.out.println("substring starts at:"+str2);
		attrValue.setText(str2);
	}
	else {
		attrValue.setText(" ");
	}
	attrValue.updateUI();
    }

    /**
     * Move layer up
     **/
    public void moveUp()
    {
	//System.out.println("Moving up :"+newCurrent.toString());
	//System.out.println("located at :"+newModel.getIndexOfChild((DefaultMutableTreeNode)newCurrent.getParent(),newCurrent));
	int posInTree=newModel.getIndexOfChild((DefaultMutableTreeNode)newCurrent.getParent(),newCurrent);
	if(posInTree!=0) {
		posInTree--;
		newModel.insertNodeInto(newCurrent,(DefaultMutableTreeNode)newCurrent.getParent(),posInTree);
		newTree.updateUI();
            renderTree(newTree,
                getParam("SEL_TEXT_NEW"), getParam("SEL_TEXT_BKG_NEW"),
                getParam("UNSEL_TEXT_NEW"),getParam("UNSEL_TEXT_BKG_NEW"),
                leafIcon_Orig,expandedIcon_Orig,collapsedIcon_Orig);
	}
    }

    /**
     * Move layer down
     **/
    public void moveDown()
    {
	//System.out.println("Moving down :"+newCurrent.toString());
	//System.out.println("located at :"+newModel.getIndexOfChild((DefaultMutableTreeNode)newCurrent.getParent(),newCurrent));
	int posInTree=newModel.getIndexOfChild((DefaultMutableTreeNode)newCurrent.getParent(),newCurrent);
	if(posInTree!=newModel.getChildCount(newCurrent.getParent())-1) {
		posInTree++;
		newModel.insertNodeInto(newCurrent,(DefaultMutableTreeNode)newCurrent.getParent(),posInTree);
		newTree.updateUI();
            renderTree(newTree,
                getParam("SEL_TEXT_NEW"), getParam("SEL_TEXT_BKG_NEW"),
                getParam("UNSEL_TEXT_NEW"),getParam("UNSEL_TEXT_BKG_NEW"),
                leafIcon_Orig,expandedIcon_Orig,collapsedIcon_Orig);
	}
	
    }
    
    
    /**
     * Shows palette
     **/
    public class dialogframe extends Frame implements WindowListener{
	JButton closeButton;
	Color currentColor;
	SimpleApplet sApplet;
	
	
	public dialogframe(String title,SimpleApplet j1){
	    super(title);
	    sApplet=j1;
	    setLayout(null);
	    currentColor=Color.green;
	    final JColorChooser tcc = new JColorChooser();
	    
	    tcc.getSelectionModel().addChangeListener(
		new ChangeListener() {
		public void stateChanged(ChangeEvent e) {
		currentColor = tcc.getColor();
		//banner.setForeground(newColor);
		}
		}
	    );
	    tcc.setBorder(BorderFactory.createTitledBorder("Choose Text Color"));
           add(tcc);
	   closeButton=new JButton("Update");
	   //closeButton.setFont(new Font("Helvetica", Font.PLAIN, 11));
           add(closeButton);
 	   tcc.setBounds(1,2,300,400);
	   closeButton.setBounds(60,405,150,30);
	   closeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				hide();
				dispose();
			}
		});
	   JLabel l1=new JLabel("Click Select on main screen to reflect choice");
	   add(l1);
	   l1.setBounds(2,2,350,40);
	    
	}
	

	public boolean handleEvent(Event e)
   	{
      		if (e.id == Event.WINDOW_DESTROY)
         	{
			//System.out.println("Setting output now");
			sApplet.colorButton.setText("Palette");
                        sApplet.updateRGB(currentColor);
                        sApplet.colorSample.setBackground(currentColor);
		 	hide( );
            		dispose( );
         	}
      		return super.handleEvent(e);

 	}

	public void windowClosing(WindowEvent e)
	{
	    System.exit(0);
	}
	public void windowClosed(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
	public void windowOpened(WindowEvent e) {}
	public void windowActivated(WindowEvent e) {}
	public void windowDeactivated(WindowEvent e) {}
	

    }
    /**
     * Shows result of start of service
     **/
    public class resultframe extends Frame implements WindowListener{
	JButton closeButton;
	
	public resultframe(String Msg){
	    //super(title);
	    setLayout(null);
	
	    JLabel l1=new JLabel(Msg);
	    l1.setFont(new Font("Serif", Font.BOLD, 20));
	    l1.setForeground(Color.black);
	    //l1.setBackground(Color.black);
	
	   add(l1);
	   l1.setBounds(2,2,500,100);
	   closeButton=new JButton("Close");
           add(closeButton);
	   closeButton.setBounds(25,405,150,30);
	   
	}
	
	public boolean handleEvent(Event e)
   	{
      		if (e.id == Event.WINDOW_DESTROY)
         	{
		 	hide( );
            		dispose( );
         	}
      		return super.handleEvent(e);

 	}
	public void windowClosing(WindowEvent e)
	{
	    System.exit(0);
	}
	public void windowClosed(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
	public void windowOpened(WindowEvent e) {}
	public void windowActivated(WindowEvent e) {}
	public void windowDeactivated(WindowEvent e) {}
	

    }

    /**
     * Common listener for elements
     **/
    class GlobalListener implements ActionListener {
	public GlobalListener() {}
	
	public void actionPerformed(ActionEvent e) {
		//System.out.println("***Action performed :"+e.getActionCommand());
		if(e.getActionCommand().equals("Add Layer")) {
			DefaultMutableTreeNode n2=oldCurrent;
			System.out.println("oldCurrent:"+oldCurrent.toString());
			tree1Add(n2);
			oldCurrent1=oldCurrent;
		}
		else if(e.getActionCommand().equals("Remove Layer")) {
			tree1Remove();
		}
		else if(e.getActionCommand().equals("Start Service")) {
			startService();
		}
		else if(e.getActionCommand().equals("Modify Renderer")) {
			modifyRenderer();
		}
		else if(e.getActionCommand().equals("Save Tree")) {
			//modifyRenderer();
		}
		else if(e.getActionCommand().equals("Update Main View")) {
		    updateRendererXML();
		}
		else if(e.getActionCommand().equals("Delete Node")) {
		    deleteRendererNode();
		}
		else if(e.getActionCommand().equals("Cancel")) {
		    showTreeUI();
		}
		else if(e.getActionCommand().equals("Update")) {
		    updateAttrib();
		}
		else if(e.getActionCommand().equals("Move Up")) {
		    moveUp();
		}
		else if(e.getActionCommand().equals("Move Down")) {
		    moveDown();
		}
		else if(e.getActionCommand().equals("Help")) {
		    showHelp();
		}
	}

    }

    /**
     * Common listener for renderer elements
     **/
    class RendererListener implements ActionListener {
	String evtSource;
	public RendererListener(String src) {
		evtSource=src;
	}
	
	public void actionPerformed(ActionEvent e) {
		//System.out.println("###Action performed :"+e.getActionCommand());
		//System.out.println("###Renderer Action performed :"+e.getActionCommand());
		if(evtSource.equals("Extended")) {
			addExtended();
		}
		else if(evtSource.equals("UpdateAttrib")) {
			updateAttrib();
		}
		else if(evtSource.equals("AddRenderer")) {
			addRndrer();
		}
		else if(evtSource.equals("AddSymbol")) {
		    addSymbols();
		}
		else if(evtSource.equals("UpdateField")) {
		    updateFld();
		}
		else if(evtSource.equals("ColorButton")) {
		    if(!isPaletteVisible) {
			paletteWindow.setVisible(true);
			isPaletteVisible=true;
			colorButton.setText("Close Palette");
			//System.out.println("Setting isPaletteVisible true");
		    }
		    else {
			paletteWindow.setVisible(false);
			isPaletteVisible=false;
			colorButton.setText("Palette");
			
			//System.out.println("Current Color :"+paletteWindow.currentColor);
			updateRGB(paletteWindow.currentColor);
				colorSample.setBackground(paletteWindow.currentColor);
		    }
		}
		else if(evtSource.equals("UpdateColor")) {
		    updColor();
		}
	}

    }
    
}
