
////package com.esri.newclass;

/**
 * Import packages to perform different funcionallity for bean.
 */
import java.io.*;
import java.util.*;
import java.lang.*;


/**
 * Import the AppServerLink class.  The AppServerLink class is the connection between the Map class
 * and the AppServer.
 */
import com.esri.aims.mtier.beans.AppServerLink;

public class Maptestmel {

  public boolean debugOn=false;
  public boolean functionDebug=false;
  /**
   * All public information can be accessed publicly. In the samples you will notice
   * times where different public variables are passed.
   */

  //Envelope information.
  public String envXMin;              //Current envelope XMin.
  public String envXMax;              //Current envelope XMax.
  public String lastenvYMin;              //Current envelope YMin.
  public String lastenvYMax;              //Current envelope YMax.
  public String lastenvXMin;              //Current envelope XMin.
  public String lastenvXMax;              //Current envelope XMax.
  public String envYMin;              //Current envelope YMin.
  public String envYMax;              //Current envelope YMax.
  public String fullExtentXMin;       //Envelope XMin for full extent.
  public String fullExtentXMax;       //Envelope XMax for full extent.
  public String fullExtentYMin;       //Envelope YMin for full extent.
  public String fullExtentYMax;       //Envelope YMax for full extent.
  public String gXMin;                //Envelope XMin for geocode extent.
  public String gXMax;                //Envelope XMax for geocode extent.
  public String gYMax;                //Envelope YMax for geocode extent.
  public String gYMin;                //Envelope Ymin for geocode extent.

  //AXLRequest & AXLResponse information.
  public String AXLResponse;      //AXLResponse sent from the server.
  public String AXLRequest;       //AXLRequest sent to the server.
  public String geocodeAXLResponse;  //Geocode AXL Response sent from the server.
  public String extractAXL;       //Extract request sent to the server.

  //MAP information;
  public String serviceName;        //mapservice name
  public String mapURL;             //map image's url
  public String background;         //background color of map
  public String iMap;               //image map html string
  public String mapUnits;           //stores the map's units.
  public double mWidth;             //map image's width
  public double mHeight;            //map image's height

  //Layer information;
  public String LayerType;          //Individual layers type
  public String LayerVisible;       //Individual layers visible
  public String LayerName;          //Individual layers name
  public String LayerID;            //Individual layers ID
  public String LayerFClass;        //Individual layers feature class
  public String LayerMinX;          //Individual layers MinX
  public String LayerMinY;          //Individual layers MinY
  public String LayerMaxX;          //Individual layers MaxX
  public String LayerMaxY;          //Individual layers MaxY
  public String layerCount;         //Number of layers -- used internally for parsing

  //Legend information -- all used internally.  These are set in the LegendObject
  public String legBackground;      //Legends background color
  public String legCellSpacing;     //Legends cell spacing
  public String legFontSize;        //Legends font size
  public String legHeight;          //Legends height
  public String legLayerFontSize;   //Legends layer font size
  public String legFont;            //Legends font
  public String legTitle;           //Legends title
  public String legTitleFontSize;   //Legends title font size
  public String legWidth;           //Legends width

  //Testers---used internally
  public boolean init;
  public String version;

  //Utilities for coordinate conversion between pixel and real world.
  public double toMapPointX;      //real world X
  public double toMapPointY;      //real world Y
  public double fromMapPointX;    //pixel X
  public double fromMapPointY;    //pixel Y
  double xIncr;                   //used internally for conversion
  double yIncr;                   //used internally for conversion

  /**
   * Creates a new instance of The AppServerLink Object.
   */

  AppServerLink appClient = new AppServerLink();

  /**
   * public void initMap(String mapService) is the initializing method.  This gets all of the information
   * about the assigned mapservice and assigns the values to ArrayLists.
   */


  /**
   * public void setWidth(long width) method sets the image's width property.
   */

  public void setWidth(long width){
      mWidth = width;
  }

  /**
   * public String getWidth() method returns the image's width property.
   */

  public String getWidth(){
      return String.valueOf(mWidth);
  }

  /**
   * public void setHeight(long height) method sets the image's height property.
   */

  public void setHeight(long height){
      mHeight = height;
  }

  /**
   * public String getHeight() method returns the image's height property.
   */

  public String getHeight(){
      return String.valueOf(mHeight);
  }

  /**
   * public void setBackground(String R, String G, String B) sets the background
   * color for the map image.
   */

  public void setBackground(String R, String G, String B){
  background = R + "," + G + "," + B;
  }
  /**
   * public void setEnvelope(double xMin, double xMax, double yMin, double yMax) method sets an extent
   * envelope.
   */

  public void setEnvelope(double xMin, double xMax, double yMin, double yMax){
      lastenvXMax=envXMax;
      lastenvXMin=envXMin;
      lastenvYMax=envYMax;
      lastenvYMin=envYMin;

      envXMax = String.valueOf(xMax);
      envYMax = String.valueOf(yMax);
      envXMin = String.valueOf(xMin);
      envYMin = String.valueOf(yMin);
  }

  /**
   * public void centerAt(String X, String Y) method centers the image to passed X, and Y values.
   */

  public void centerAt(String X, String Y){
      double tmpXMin;
      double tmpXMax;
      double tmpYMin;
      double tmpYMax;
      double mapWidth;
      double mapHeight;
      double halfWidth;
      double halfHeight;
      double xIncrement;
      double yIncrement;
      double imagey;
      double imagex;
      double centerx;
      double centery;

      mapWidth = Double.parseDouble(envXMax) - Double.parseDouble(envXMin);
      mapHeight = Double.parseDouble(envYMax) - Double.parseDouble(envYMin);

      halfWidth = mapWidth / 2;
      halfHeight = mapHeight / 2;

      xIncrement = mapWidth / mWidth;
      yIncrement = mapHeight / mHeight;

      imagey = mHeight - Double.parseDouble(Y);

      centerx = Double.parseDouble(X) * xIncrement + Double.parseDouble(envXMin);
      centery = imagey * yIncrement + Double.parseDouble(envYMin);

      tmpXMin = centerx - halfWidth;
      tmpYMin = centery - halfHeight;
      tmpXMax = centerx + halfWidth;
      tmpYMax = centery + halfHeight;


      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
      envXMin = String.valueOf(tmpXMin);
      envXMax = String.valueOf(tmpXMax);
      envYMax = String.valueOf(tmpYMax);
      envYMin = String.valueOf(tmpYMin);
  }

  /**
   * public void toMapPoint(String X, String Y) method converts passed X, and Y values in pixel to
   * real world coordinates and sets then to the toMapPointX, and toMapPointY variables.
   */

  public void toMapPoint(String X, String Y){
      double toMapWidth;
      double toMapHeight;
      double toXIncrement;
      double toYIncrement;
      double toYCoord;

      toMapWidth = Double.parseDouble(envXMax) - Double.parseDouble(envXMin);
      toMapHeight = Double.parseDouble(envYMax) - Double.parseDouble(envYMin);

      toXIncrement = toMapWidth / mWidth;
      toYIncrement = toMapHeight / mHeight;

      toYCoord = mHeight - Double.parseDouble(Y);

      toMapPointX = Double.parseDouble(X) * toXIncrement + Double.parseDouble(envXMin);
      toMapPointY = toYCoord * toYIncrement + Double.parseDouble(envYMin);
  }

  /**
   * public void fromMapPoint(String X, String Y) method converts passed real world coordinates to pixel
   * coordinates.
   */

  public void fromMapPoint(String X, String Y){
      xIncr = (Double.parseDouble(envXMax) - Double.parseDouble(envXMin)) / mWidth;
      yIncr = (Double.parseDouble(envYMax) - Double.parseDouble(envYMin)) / mHeight;
      fromMapPointX = (Double.parseDouble(X) - Double.parseDouble(envXMin)) / xIncr;
      fromMapPointY = (Double.parseDouble(envYMax) - Double.parseDouble(Y)) / yIncr;
  }


  /**
   * public void doZoom(long scaleFactor) method creates different envelopes to zoom to based
   * on the scaleFactor argument.  A negative number will zoom out, positive to zoom in.
   */

  public void doZoom(long scaleFactor){
      double width;
      double height;
      double centerX;
      double centerY;
      double sc;

      sc = Math.abs(scaleFactor) + 1;

      width = (Double.parseDouble(envXMax) - Double.parseDouble(envXMin)) / 2;
      height = (Double.parseDouble(envYMax) - Double.parseDouble(envYMin)) / 2;
      centerX = width + Double.parseDouble(envXMin);
      centerY = height + Double.parseDouble(envYMin);

      if (scaleFactor < 0 ){
          width = width * sc;
          height = height * sc;
      }

      if (scaleFactor > 0){
          width = width / sc;
          height = height / sc;
      }

      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
      envXMin = String.valueOf(centerX - width);
      envYMin = String.valueOf(centerY - height);
      envXMax = String.valueOf(centerX + width);
      envYMax = String.valueOf(centerY + height);
  }

  /**
   * public void doPan(long direction, double step) method is for directional panning.  Directions are 1 - 8 and
   * are passed as the direction, the step is the amount of shift to take on the pan.
   */

  public void doPan(long direction, double step){
      double W10;
      double H10;

      W10 = (Double.parseDouble(envXMax) - Double.parseDouble(envXMin)) / 10 * Math.abs(step);
      H10 = (Double.parseDouble(envYMax) - Double.parseDouble(envYMin)) / 10 * Math.abs(step);



    //Direction 1 = Pan North

      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
  if(direction == 1){
      envYMin = String.valueOf(Double.parseDouble(envYMin) + H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) + H10);
      envXMax = String.valueOf(Double.parseDouble(envXMax));
      envXMin = String.valueOf(Double.parseDouble(envXMin));
  }


    //Direction 2 = Pan Northeast


  if(direction == 2){
      envYMin = String.valueOf(Double.parseDouble(envYMin) + H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) + H10);
      envXMin = String.valueOf(Double.parseDouble(envXMin) + W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) + W10);
  }


   //Direction 3 = Pan East


  if(direction == 3){
      envXMin = String.valueOf(Double.parseDouble(envXMin) + W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) + W10);
      envYMax = String.valueOf(Double.parseDouble(envYMax));
      envYMin = String.valueOf(Double.parseDouble(envYMin));
  }


  //Direction 4 = Pan Southeast


  if(direction == 4){
      envYMin = String.valueOf(Double.parseDouble(envYMin) - H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) - H10);
      envXMin = String.valueOf(Double.parseDouble(envXMin) + W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) + W10);
  }


   //Direction 5 = Pan South


  if(direction == 5){
      envYMin = String.valueOf(Double.parseDouble(envYMin) - H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) - H10);
      envXMax = String.valueOf(Double.parseDouble(envXMax));
      envXMin = String.valueOf(Double.parseDouble(envXMin));
  }


   //Direction 6 = Pan Southwest


  if(direction == 6){
      envYMin = String.valueOf(Double.parseDouble(envYMin) - H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) - H10);
      envXMin = String.valueOf(Double.parseDouble(envXMin));
      envYMin = String.valueOf(Double.parseDouble(envYMin));
  }


   //Direction 7 = Pan West


  if(direction == 7){
      envXMin = String.valueOf(Double.parseDouble(envXMin) - W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) - W10);
      envYMax = String.valueOf(Double.parseDouble(envYMax));
      envYMin = String.valueOf(Double.parseDouble(envYMin));
  }


   //Direction 8 = Pan Northwest


  if(direction == 8){
      envYMin = String.valueOf(Double.parseDouble(envYMin) + W10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) + W10);
      envXMin = String.valueOf(Double.parseDouble(envXMin) - W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) - W10);
  }
}

/**
 *  public void doZoomToFullExtent() method sets the envelope to the inital extent.
 */

public void doZoomToFullExtent(){
      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
    envXMin = String.valueOf(fullExtentXMin);
    envYMin = String.valueOf(fullExtentYMin);
    envXMax = String.valueOf(fullExtentXMax);
    envYMax = String.valueOf(fullExtentYMax);
}

/**
 * public void doZoomToExtent() sets the current extent of the map to the passed
 * coordinate arguments.
 */

public void doZoomToExtent(String XMin, String XMax, String YMin, String YMax){
      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
    envXMin = XMin;
    envXMax = XMax;
    envYMin = YMin;
    envYMax = YMax;
}

/**
 * public void createGeocodeExtent() creates an extents based on an output geocode X, and geocode Y
 * coordinate.  The extent is stored with in the gXMin, gXMax, gYMin, gYMax string variables.
 */

public void createGeocodeExtent(String X, String Y){

    gXMin = String.valueOf(Double.parseDouble(X) - 0.009);
    gXMax = String.valueOf(Double.parseDouble(X) + 0.009);
    gYMin = String.valueOf(Double.parseDouble(Y) - 0.009);
    gYMax = String.valueOf(Double.parseDouble(Y) + 0.009);
}

/**
 *  public void sendAXLRequest(String serviceName, String AXLRequest) method sends the Request
 *  to the AppServerLink class.  The AppServerLink then sends the request to the
 *  Application Server.
 */

public void sendAXLRequest(String serviceName, String AXLRequest){
    if(debugOn) {
	//System.out.println("In beginning of sendAXLRequest");
	System.out.println("Sending to " + serviceName + " AXLRequest : \n" + AXLRequest);
    }
    if(functionDebug) {
	//System.out.println("Sending to " + serviceName + " AXLRequest : \n" + AXLRequest);
    }
    appClient.sendAXLRequest(serviceName, AXLRequest, null);
    if(debugOn) {
	System.out.println("sent request");
    }
    AXLResponse = appClient.getResponseAXL();
    if(functionDebug) {
	System.out.println("Got back : "+AXLResponse);
    }
    if(debugOn) {
	System.out.println("At end of sendAXLRequest");
    }
}
/**
 * public void setParams(String appServerHost, int appServerPort) method sets the server name, and server port.
 */

public void setParams(String appServerHost, int appServerPort){
    appClient.setAppServerHost(appServerHost);
    appClient.setAppServerPort(appServerPort);
    if(debugOn) {
	System.out.println("Done with setParams");
    }
}


/**
 * public void setServiceName(String mapService) method sets the serviceName property.
 */

public void setServiceName(String mapService){
serviceName = mapService;
}

/**
 * public void getServiceName() method returns the serviceName property.
 */

public String getServiceName(){
    return serviceName;
}


/**
 * public void getImageASUrl(String ImageAXLResponse) method parses the response for both the
 * map image, and the legend image.  The legend image tag is passed onto the Legend
 * object to parsed for the url.
 */

public String getImageAsUrl(String ImageAXLResponse){
    String parseAXLResponse = ImageAXLResponse;
    String eminX;
    String eminY;
    String emaxX;
    String emaxY;

    int ebminX = parseAXLResponse.indexOf("minx") + 6;
    int eeminX = parseAXLResponse.indexOf('"',ebminX);
    eminX = String.valueOf(parseAXLResponse.substring(ebminX, eeminX));

    int ebminY = parseAXLResponse.indexOf("miny") + 6;
    int eeminY = parseAXLResponse.indexOf('"',ebminY);
    eminY = String.valueOf(parseAXLResponse.substring(ebminY, eeminY));

    int ebmaxX = parseAXLResponse.indexOf("maxx") + 6;
    int eemaxX = parseAXLResponse.indexOf('"',ebmaxX) - 2;
    emaxX = String.valueOf(parseAXLResponse.substring(ebmaxX, eemaxX));

    int ebmaxY = parseAXLResponse.indexOf("maxy") + 6;
    int eemaxY = parseAXLResponse.indexOf('"',ebmaxY) - 7;
    emaxY = String.valueOf(parseAXLResponse.substring(ebmaxY, eemaxY));

    envXMax = emaxX;
    envYMax = emaxY;
    envXMin = eminX;
    envYMin = eminY;
   /* getOV().lmaxx = emaxX;
    getOV().lmaxy = emaxY;
    getOV().lminx = eminX;
    getOV().lminy = eminY;*/

    int beginMapUrl = parseAXLResponse.indexOf("url") + 5;
    int endMapUrl = parseAXLResponse.indexOf('"', beginMapUrl);
    mapURL = parseAXLResponse.substring(beginMapUrl, endMapUrl);// + ".png";
	/*if(parseAXLResponse.indexOf("<LEGEND>")!=-1) {
	    int beginLegend = parseAXLResponse.indexOf("<LEGEND");
	    int endLegend = parseAXLResponse.indexOf("</IMAGE>");
	    String legURL = String.valueOf(parseAXLResponse.substring(beginLegend, endLegend));
	    setLegend().setLegendURL(legURL);
	}*/
return mapURL ;
}







  
   public String getClientImageString() {
	return("<input type=image class='imageStyle' src='" + mapURL + "'>");
   }
}

