////package com.esri.newclass;

/**
 * Import packages to perform different funcionallity for bean.
 */
import java.io.*;
import java.util.*;
import java.lang.*;

/**
 * Import the AppServerLink class.  The AppServerLink class is the connection between the Map class
 * and the AppServer.
 */
import com.esri.aims.mtier.beans.AppServerLink;

public class Maptest {

  public boolean debugOn=false;
  public boolean functionDebug=false;
  /**
   * All public information can be accessed publicly. In the samples you will notice
   * times where different public variables are passed.
   */

  //Envelope information.
  public String envXMin;              //Current envelope XMin.
  public String envXMax;              //Current envelope XMax.
  public String lastenvYMin;              //Current envelope YMin.
  public String lastenvYMax;              //Current envelope YMax.
  public String lastenvXMin;              //Current envelope XMin.
  public String lastenvXMax;              //Current envelope XMax.
  public String envYMin;              //Current envelope YMin.
  public String envYMax;              //Current envelope YMax.
  public String fullExtentXMin;       //Envelope XMin for full extent.
  public String fullExtentXMax;       //Envelope XMax for full extent.
  public String fullExtentYMin;       //Envelope YMin for full extent.
  public String fullExtentYMax;       //Envelope YMax for full extent.
  public String gXMin;                //Envelope XMin for geocode extent.
  public String gXMax;                //Envelope XMax for geocode extent.
  public String gYMax;                //Envelope YMax for geocode extent.
  public String gYMin;                //Envelope Ymin for geocode extent.

  //AXLRequest & AXLResponse information.
  public String AXLResponse;      //AXLResponse sent from the server.
  public String AXLRequest;       //AXLRequest sent to the server.
  public String geocodeAXLResponse;  //Geocode AXL Response sent from the server.
  public String extractAXL;       //Extract request sent to the server.

  //MAP information;
  public String serviceName;        //mapservice name
  public String mapURL;             //map image's url
  public String background;         //background color of map
  public String iMap;               //image map html string
  public String mapUnits;           //stores the map's units.
  public double mWidth;             //map image's width
  public double mHeight;            //map image's height

  //Layer information;
  public String LayerType;          //Individual layers type
  public String LayerVisible;       //Individual layers visible
  public String LayerName;          //Individual layers name
  public String LayerID;            //Individual layers ID
  public String LayerFClass;        //Individual layers feature class
  public String LayerMinX;          //Individual layers MinX
  public String LayerMinY;          //Individual layers MinY
  public String LayerMaxX;          //Individual layers MaxX
  public String LayerMaxY;          //Individual layers MaxY
  public String layerCount;         //Number of layers -- used internally for parsing

  //Legend information -- all used internally.  These are set in the LegendObject
  public String legBackground;      //Legends background color
  public String legCellSpacing;     //Legends cell spacing
  public String legFontSize;        //Legends font size
  public String legHeight;          //Legends height
  public String legLayerFontSize;   //Legends layer font size
  public String legFont;            //Legends font
  public String legTitle;           //Legends title
  public String legTitleFontSize;   //Legends title font size
  public String legWidth;           //Legends width

  //Testers---used internally
  public boolean init;
  public String version;

  //Utilities for coordinate conversion between pixel and real world.
  public double toMapPointX;      //real world X
  public double toMapPointY;      //real world Y
  public double fromMapPointX;    //pixel X
  public double fromMapPointY;    //pixel Y
  double xIncr;                   //used internally for conversion
  double yIncr;                   //used internally for conversion

  /**
   * Creates a new instance of The AppServerLink Object.
   */

  AppServerLink appClient = new AppServerLink();

  /**
   * Creates a new instance of the Layers Object.
   */

  Layerstest theLayers = new Layerstest();
  private Layerstest layers = theLayers;

  /**
   * Creates a new instance of the Extract Object.
   */
  Extract ext = new Extract();
  private Extract extract = ext;

  /**
   * Creates a new instance of the Legend Object.
   */

  Legend theLegend = new Legend();
  private Legend legend = theLegend;

  /**
   * Creates a new instance of the OverviewMap Object.
   */

  Overviewmap ov = new Overviewmap();
  private Overviewmap ovmap = ov;


  public void setDebugOn(boolean value)
  {
      debugOn=value;
  }
  public void setFunctionDebug(boolean value)
  {
      functionDebug=value;
  }
  /**
   * public void initMap(String mapService) is the initializing method.  This gets all of the information
   * about the assigned mapservice and assigns the values to ArrayLists.
   */

  public void initMap(String mapService){
      if(debugOn) {
	System.out.println("In beginning of initmap, mapService="+mapService);
      }
      StringBuffer sibf = new StringBuffer();
      String serviceInfo;
      String parseServiceInfo;
      String bigServiceInfo;

      sibf.append("<ARCXML version='1.0.1'>");
      sibf.append("<REQUEST>");
      sibf.append("<GET_SERVICE_INFO fields='true' envelope='true' extension='false' renderer='true' />");
      sibf.append("</REQUEST>");
      sibf.append("</ARCXML>");

      serviceInfo = sibf.toString();
      sendAXLRequest(mapService, serviceInfo);
      setServiceName(mapService);
  
      parseServiceInfo = AXLResponse;
	functionDebug=true;
      if(functionDebug) {
	System.out.println("Begining to parse response"+AXLResponse);
      }
	functionDebug=false;
	if(parseServiceInfo.indexOf("<ERROR ")==-1) {
      int ArcXMLb = parseServiceInfo.indexOf("ARCXML") + 16;
      int ArcXMLe = parseServiceInfo.indexOf("<RESPONSE>") - 3;
      version = parseServiceInfo.substring(ArcXMLb, ArcXMLe);

      int beginMinX = parseServiceInfo.indexOf("minx") + 6;
      int endMinX = parseServiceInfo.indexOf("miny") - 2;
      fullExtentXMin = parseServiceInfo.substring(beginMinX, endMinX);

      int beginMinY = parseServiceInfo.indexOf("miny") + 6;
      int endMinY = parseServiceInfo.indexOf("maxx") - 2;
      fullExtentYMin = parseServiceInfo.substring(beginMinY, endMinY);

      int beginMaxX = parseServiceInfo.indexOf("maxx") + 6;
      int endMaxX = parseServiceInfo.indexOf("maxy") - 2;
      fullExtentXMax = parseServiceInfo.substring(beginMaxX, endMaxX);

      int beginMaxY = parseServiceInfo.indexOf("maxy") + 6;
      int endMaxY = parseServiceInfo.indexOf("Initial") - 8;
      fullExtentYMax = parseServiceInfo.substring(beginMaxY, endMaxY);

      try{
          this.getLayers().renderer().setRendAXL(parseServiceInfo);
      }

      catch(Exception e){
          System.out.println(e.getMessage());
      }


      int serviceInfoStart = parseServiceInfo.indexOf("<MAPUNITS ");
      int serviceInfoEnd = parseServiceInfo.indexOf("</SERVICEINFO>") + 14;
      bigServiceInfo = parseServiceInfo.substring(serviceInfoStart, serviceInfoEnd);

      try{
              createLayerInfo(bigServiceInfo);
      }
      catch(Exception e){
          System.out.println(e.getMessage());
      }

      if(envXMax == null){
          lastenvXMax=envXMax = fullExtentXMax;
          lastenvXMin=envXMin = fullExtentXMin;
          lastenvYMax=envYMax = fullExtentYMax;
          lastenvYMin=envYMin = fullExtentYMin;
          getOV().minx = fullExtentXMin;
          getOV().miny = fullExtentYMin;
          getOV().maxx = fullExtentXMax;
          getOV().maxy = fullExtentYMax;
      }

     getLayers().acetate().getNorthArrow().setVersion(version);
     getLayers().acetate().setVersion(version);

      init = true;
	}

      if(functionDebug) {
	System.out.println("End of initmap");
      }
  }

  /**
   * public void setWidth(long width) method sets the image's width property.
   */

  public void setWidth(long width){
      mWidth = width;
  }

  /**
   * public String getWidth() method returns the image's width property.
   */

  public String getWidth(){
      return String.valueOf(mWidth);
  }

  /**
   * public void setHeight(long height) method sets the image's height property.
   */

  public void setHeight(long height){
      mHeight = height;
  }

  /**
   * public String getHeight() method returns the image's height property.
   */

  public String getHeight(){
      return String.valueOf(mHeight);
  }

  /**
   * public void setBackground(String R, String G, String B) sets the background
   * color for the map image.
   */

  public void setBackground(String R, String G, String B){
  background = R + "," + G + "," + B;
  }
  /**
   * public void setEnvelope(double xMin, double xMax, double yMin, double yMax) method sets an extent
   * envelope.
   */

  public void setEnvelope(double xMin, double xMax, double yMin, double yMax){
      lastenvXMax=envXMax;
      lastenvXMin=envXMin;
      lastenvYMax=envYMax;
      lastenvYMin=envYMin;

      envXMax = String.valueOf(xMax);
      envYMax = String.valueOf(yMax);
      envXMin = String.valueOf(xMin);
      envYMin = String.valueOf(yMin);
  }

  /**
   * public void centerAt(String X, String Y) method centers the image to passed X, and Y values.
   */

  public void centerAt(String X, String Y){
      double tmpXMin;
      double tmpXMax;
      double tmpYMin;
      double tmpYMax;
      double mapWidth;
      double mapHeight;
      double halfWidth;
      double halfHeight;
      double xIncrement;
      double yIncrement;
      double imagey;
      double imagex;
      double centerx;
      double centery;

      mapWidth = Double.parseDouble(envXMax) - Double.parseDouble(envXMin);
      mapHeight = Double.parseDouble(envYMax) - Double.parseDouble(envYMin);

      halfWidth = mapWidth / 2;
      halfHeight = mapHeight / 2;

      xIncrement = mapWidth / mWidth;
      yIncrement = mapHeight / mHeight;

      imagey = mHeight - Double.parseDouble(Y);

      centerx = Double.parseDouble(X) * xIncrement + Double.parseDouble(envXMin);
      centery = imagey * yIncrement + Double.parseDouble(envYMin);

      tmpXMin = centerx - halfWidth;
      tmpYMin = centery - halfHeight;
      tmpXMax = centerx + halfWidth;
      tmpYMax = centery + halfHeight;


      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
      envXMin = String.valueOf(tmpXMin);
      envXMax = String.valueOf(tmpXMax);
      envYMax = String.valueOf(tmpYMax);
      envYMin = String.valueOf(tmpYMin);
  }

  /**
   * public void toMapPoint(String X, String Y) method converts passed X, and Y values in pixel to
   * real world coordinates and sets then to the toMapPointX, and toMapPointY variables.
   */

  public void toMapPoint(String X, String Y){
      double toMapWidth;
      double toMapHeight;
      double toXIncrement;
      double toYIncrement;
      double toYCoord;

      toMapWidth = Double.parseDouble(envXMax) - Double.parseDouble(envXMin);
      toMapHeight = Double.parseDouble(envYMax) - Double.parseDouble(envYMin);

      toXIncrement = toMapWidth / mWidth;
      toYIncrement = toMapHeight / mHeight;

      toYCoord = mHeight - Double.parseDouble(Y);

      toMapPointX = Double.parseDouble(X) * toXIncrement + Double.parseDouble(envXMin);
      toMapPointY = toYCoord * toYIncrement + Double.parseDouble(envYMin);
  }

  /**
   * public void fromMapPoint(String X, String Y) method converts passed real world coordinates to pixel
   * coordinates.
   */

  public void fromMapPoint(String X, String Y){
      xIncr = (Double.parseDouble(envXMax) - Double.parseDouble(envXMin)) / mWidth;
      yIncr = (Double.parseDouble(envYMax) - Double.parseDouble(envYMin)) / mHeight;
      fromMapPointX = (Double.parseDouble(X) - Double.parseDouble(envXMin)) / xIncr;
      fromMapPointY = (Double.parseDouble(envYMax) - Double.parseDouble(Y)) / yIncr;
  }


  /**
   * public void doZoom(long scaleFactor) method creates different envelopes to zoom to based
   * on the scaleFactor argument.  A negative number will zoom out, positive to zoom in.
   */

  public void doZoom(long scaleFactor){
      double width;
      double height;
      double centerX;
      double centerY;
      double sc;

      sc = Math.abs(scaleFactor) + 1;

      width = (Double.parseDouble(envXMax) - Double.parseDouble(envXMin)) / 2;
      height = (Double.parseDouble(envYMax) - Double.parseDouble(envYMin)) / 2;
      centerX = width + Double.parseDouble(envXMin);
      centerY = height + Double.parseDouble(envYMin);

      if (scaleFactor < 0 ){
          width = width * sc;
          height = height * sc;
      }

      if (scaleFactor > 0){
          width = width / sc;
          height = height / sc;
      }

      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
      envXMin = String.valueOf(centerX - width);
      envYMin = String.valueOf(centerY - height);
      envXMax = String.valueOf(centerX + width);
      envYMax = String.valueOf(centerY + height);
  }

  /**
   * public void doPan(long direction, double step) method is for directional panning.  Directions are 1 - 8 and
   * are passed as the direction, the step is the amount of shift to take on the pan.
   */

  public void doPan(long direction, double step){
      double W10;
      double H10;

      W10 = (Double.parseDouble(envXMax) - Double.parseDouble(envXMin)) / 10 * Math.abs(step);
      H10 = (Double.parseDouble(envYMax) - Double.parseDouble(envYMin)) / 10 * Math.abs(step);



    //Direction 1 = Pan North

      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
  if(direction == 1){
      envYMin = String.valueOf(Double.parseDouble(envYMin) + H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) + H10);
      envXMax = String.valueOf(Double.parseDouble(envXMax));
      envXMin = String.valueOf(Double.parseDouble(envXMin));
  }


    //Direction 2 = Pan Northeast


  if(direction == 2){
      envYMin = String.valueOf(Double.parseDouble(envYMin) + H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) + H10);
      envXMin = String.valueOf(Double.parseDouble(envXMin) + W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) + W10);
  }


   //Direction 3 = Pan East


  if(direction == 3){
      envXMin = String.valueOf(Double.parseDouble(envXMin) + W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) + W10);
      envYMax = String.valueOf(Double.parseDouble(envYMax));
      envYMin = String.valueOf(Double.parseDouble(envYMin));
  }


  //Direction 4 = Pan Southeast


  if(direction == 4){
      envYMin = String.valueOf(Double.parseDouble(envYMin) - H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) - H10);
      envXMin = String.valueOf(Double.parseDouble(envXMin) + W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) + W10);
  }


   //Direction 5 = Pan South


  if(direction == 5){
      envYMin = String.valueOf(Double.parseDouble(envYMin) - H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) - H10);
      envXMax = String.valueOf(Double.parseDouble(envXMax));
      envXMin = String.valueOf(Double.parseDouble(envXMin));
  }


   //Direction 6 = Pan Southwest


  if(direction == 6){
      envYMin = String.valueOf(Double.parseDouble(envYMin) - H10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) - H10);
      envXMin = String.valueOf(Double.parseDouble(envXMin));
      envYMin = String.valueOf(Double.parseDouble(envYMin));
  }


   //Direction 7 = Pan West


  if(direction == 7){
      envXMin = String.valueOf(Double.parseDouble(envXMin) - W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) - W10);
      envYMax = String.valueOf(Double.parseDouble(envYMax));
      envYMin = String.valueOf(Double.parseDouble(envYMin));
  }


   //Direction 8 = Pan Northwest


  if(direction == 8){
      envYMin = String.valueOf(Double.parseDouble(envYMin) + W10);
      envYMax = String.valueOf(Double.parseDouble(envYMax) + W10);
      envXMin = String.valueOf(Double.parseDouble(envXMin) - W10);
      envXMax = String.valueOf(Double.parseDouble(envXMax) - W10);
  }
}

/**
 *  public void doZoomToFullExtent() method sets the envelope to the inital extent.
 */

public void doZoomToFullExtent(){
      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
    envXMin = String.valueOf(fullExtentXMin);
    envYMin = String.valueOf(fullExtentYMin);
    envXMax = String.valueOf(fullExtentXMax);
    envYMax = String.valueOf(fullExtentYMax);
}

/**
 * public void doZoomToExtent() sets the current extent of the map to the passed
 * coordinate arguments.
 */

public void doZoomToExtent(String XMin, String XMax, String YMin, String YMax){
      lastenvXMin=envXMin;
      lastenvXMax=envXMax;
      lastenvYMin=envYMin;
      lastenvYMax=envYMax;
    envXMin = XMin;
    envXMax = XMax;
    envYMin = YMin;
    envYMax = YMax;
}

/**
 * public void createGeocodeExtent() creates an extents based on an output geocode X, and geocode Y
 * coordinate.  The extent is stored with in the gXMin, gXMax, gYMin, gYMax string variables.
 */

public void createGeocodeExtent(String X, String Y){

    gXMin = String.valueOf(Double.parseDouble(X) - 0.009);
    gXMax = String.valueOf(Double.parseDouble(X) + 0.009);
    gYMin = String.valueOf(Double.parseDouble(Y) - 0.009);
    gYMax = String.valueOf(Double.parseDouble(Y) + 0.009);
}

/**
 *  public void sendAXLRequest(String serviceName, String AXLRequest) method sends the Request
 *  to the AppServerLink class.  The AppServerLink then sends the request to the
 *  Application Server.
 */

public void sendAXLRequest(String serviceName, String AXLRequest){
    if(debugOn) {
	//System.out.println("In beginning of sendAXLRequest");
	System.out.println("Sending to " + serviceName + " AXLRequest : \n" + AXLRequest);
    }
    if(functionDebug) {
	//System.out.println("Sending to " + serviceName + " AXLRequest : \n" + AXLRequest);
    }
    appClient.sendAXLRequest(serviceName, AXLRequest, null);
    if(debugOn) {
	System.out.println("sent request");
    }
    AXLResponse = appClient.getResponseAXL();
    if(functionDebug) {
	System.out.println("Got back : "+AXLResponse);
    }
    if(debugOn) {
	System.out.println("At end of sendAXLRequest");
    }
}

/**
 * public void getImageASUrl(String ImageAXLResponse) method parses the response for both the
 * map image, and the legend image.  The legend image tag is passed onto the Legend
 * object to parsed for the url.
 */

public void getImageAsUrl(String ImageAXLResponse){
    String parseAXLResponse = ImageAXLResponse;
    String eminX;
    String eminY;
    String emaxX;
    String emaxY;

    int ebminX = parseAXLResponse.indexOf("minx") + 6;
    int eeminX = parseAXLResponse.indexOf('"',ebminX);
    eminX = String.valueOf(parseAXLResponse.substring(ebminX, eeminX));

    int ebminY = parseAXLResponse.indexOf("miny") + 6;
    int eeminY = parseAXLResponse.indexOf('"',ebminY);
    eminY = String.valueOf(parseAXLResponse.substring(ebminY, eeminY));

    int ebmaxX = parseAXLResponse.indexOf("maxx") + 6;
    int eemaxX = parseAXLResponse.indexOf('"',ebmaxX) - 2;
    emaxX = String.valueOf(parseAXLResponse.substring(ebmaxX, eemaxX));

    int ebmaxY = parseAXLResponse.indexOf("maxy") + 6;
    int eemaxY = parseAXLResponse.indexOf('"',ebmaxY) - 7;
    emaxY = String.valueOf(parseAXLResponse.substring(ebmaxY, eemaxY));

    envXMax = emaxX;
    envYMax = emaxY;
    envXMin = eminX;
    envYMin = eminY;
    getOV().lmaxx = emaxX;
    getOV().lmaxy = emaxY;
    getOV().lminx = eminX;
    getOV().lminy = eminY;

    int beginMapUrl = parseAXLResponse.indexOf("url") + 5;
    int endMapUrl = parseAXLResponse.indexOf('"', beginMapUrl);
    mapURL = parseAXLResponse.substring(beginMapUrl, endMapUrl);// + ".png";
	if(parseAXLResponse.indexOf("<LEGEND>")!=-1) {
	    int beginLegend = parseAXLResponse.indexOf("<LEGEND");
	    int endLegend = parseAXLResponse.indexOf("</IMAGE>");
	    String legURL = String.valueOf(parseAXLResponse.substring(beginLegend, endLegend));
	    setLegend().setLegendURL(legURL);
	}

}

/**
 * public void setParams(String appServerHost, int appServerPort) method sets the server name, and server port.
 */

public void setParams(String appServerHost, int appServerPort){
    appClient.setAppServerHost(appServerHost);
    appClient.setAppServerPort(appServerPort);
    if(debugOn) {
	System.out.println("Done with setParams");
    }
}

/**
 * public void createLayerInfo(String AXL) method sends the response AXL to the
 * layer objects setLayerInfo(AXL) method to parse out information.
 */

public void createLayerInfo(String AXL) throws Exception{

    try{

          if(version.equals("1.0")){
              this.getLayers().setLayerInfo(AXL);
          }
          else{
              this.getLayers().setLayerInfo31(AXL);
          }
    }

    catch(Exception e){
          System.out.println(e.getMessage());
    }
}


/**
 * Returns the layers object.  It also sents envelope values in the layers object.
 */

public Layerstest getLayers(){
    layers.mapEnvXMin = envXMin;
    layers.mapEnvXMax = envXMax;
    layers.mapEnvYMin = envYMin;
    layers.mapEnvYMax = envYMax;
    layers.mapToMapPointX = toMapPointX;
    layers.mapToMapPointY = toMapPointY;
    return layers;
}

/**
 * Returns the Legend object, and returns the legend object.
 */

public Legend setLegend(){
    return legend;
}

/**
 * public void getLegend() method passes legend properties from the legend Object to the Map Object.
 */
public void getLegend(){
  legBackground = setLegend().getBackground();
  legCellSpacing = setLegend().getCellSpacing();
  legFontSize = setLegend().getFontSize();
  legHeight = setLegend().getHeight();
  legLayerFontSize = setLegend().getLayerFontSize();
  legFont = setLegend().getLegendFont();
  legTitle = setLegend().getTitle();
  legTitleFontSize = setLegend().getTitleFontSize();
  legWidth = setLegend().getWidth();
}

/**
 * public void setServiceName(String mapService) method sets the serviceName property.
 */

public void setServiceName(String mapService){
serviceName = mapService;
}

/**
 * public void getServiceName() method returns the serviceName property.
 */

public String getServiceName(){
    return serviceName;
}


public void refreshLayers(String mapService){
    if(debugOn) {
	System.out.println("Starting refreshLayers,mapService:" + mapService);
    }
    String parseAXLResponse;
    StringBuffer AXLbf = new StringBuffer();
    this.getLegend();

    if(version != "1.0"){
        AXLbf.append("<ARCXML version='1.1'>");
    }

    else{
        AXLbf.append("<ARCXML version='1.0.1'>");
    }


    //Request
    AXLbf.append("<REQUEST>");
    AXLbf.append("<GET_IMAGE>");
    AXLbf.append("<PROPERTIES>");
    if(background != null){
    if(functionDebug) {
	System.out.println("Found background set already, hence generating XML");
	System.out.println("--background:"+background);
    }
	AXLbf.append("<BACKGROUND color='" + background + "' trans='" + background + "' />");

    }
     AXLbf.append("<LEGEND ");
    if(legTitle != null){
        AXLbf.append("title='" + legTitle + "' ");
    }
    if(legFont != null){
        AXLbf.append("font='" + legFont + "' ");
    }
    if(legWidth != null){
        AXLbf.append("width='" + legWidth + "' ");
    }
    if(legWidth == null){
        AXLbf.append("width='200' ");
    }
    if(legHeight != null){
        AXLbf.append("height='" + legHeight + "' ");
    }
    if(legHeight == null){
        AXLbf.append("height='600' ");
    }
    if(legBackground != null){
        AXLbf.append("background='" + legBackground + "' ");
    }
    if(legBackground == null){
        AXLbf.append("background='255,255,255' ");
    }
    if(legCellSpacing != null){
        AXLbf.append("cellspacing='" + legCellSpacing + "' ");
    }
    if(legTitleFontSize != null){
        AXLbf.append("titlefontsize='" + legTitleFontSize + "' ");
    }

    if(legLayerFontSize != null){
        AXLbf.append("layerfontsize='" + legLayerFontSize + "' ");
    }

    if(legFontSize != null){
        AXLbf.append("titlefontsize='" + legFontSize + "' ");
    }

    AXLbf.append(" />");

   //Envelope

   AXLbf.append("<ENVELOPE minx='" + envXMin + "' miny='" + envYMin + "' maxx='" + envXMax + "' maxy='" + envYMax + "' />");


   //Image size

   AXLbf.append("<IMAGESIZE width='" + String.valueOf(mWidth) + "' height='" + String.valueOf(mHeight) + "' />");


   AXLbf.append(this.getLayers().createSortLayerAXL());


  AXLbf.append("</PROPERTIES>");
  if(getLayers().addedshape != null){
      AXLbf.append(getLayers().addedshape);
  }
  if(getLayers().acetate().AcetateList.size() > 0){
      for(int i = 0; i < getLayers().acetate().AcetateList.size(); i++){
          AXLbf.append(getLayers().acetate().AcetateList.get(i).toString());
      }
  }

  AXLbf.append("</GET_IMAGE>");

  AXLbf.append("</REQUEST>");

  AXLbf.append("</ARCXML>");


  AXLRequest = AXLbf.toString();
  sendAXLRequest(mapService, AXLRequest);
  parseAXLResponse = AXLResponse;
  getImageAsUrl(parseAXLResponse);

  setServiceName(mapService);
    if(debugOn) {
	System.out.println("Ending refreshLayers,mapURL:" + mapURL);
    }
}

/**
 * public void refresh(String mapService, boolean getFeatures, String AXLConstruct) method refreshes the map.
 * if doing an identify the getFeatures must equal true, and the returned value from the doIdentify method
 * is passed through the AXLConstruct argument.  The AXLConstruct argument is only used for the doIdentify.
 */
public void refresh(String mapService, boolean getFeatures, boolean geocode, String AXLConstruct){
    if(debugOn) {
	System.out.println("Starting refresh,mapService:" + mapService);
    }

    String parseAXLResponse;
    StringBuffer AXLbf = new StringBuffer();
    this.getLegend();
    if(functionDebug) {
	System.out.println("after getLegend");
    }
    if(version != "1.0"){
        AXLbf.append("<ARCXML version='1.1'>");
    }

    else{
        AXLbf.append("<ARCXML version='1.0.1'>");
    }

    if(functionDebug) {
        System.out.println("after append");
    }
    //Request
    AXLbf.append("<REQUEST>");

    if(geocode == false){


     // Get Image

    if(getFeatures != true){
    AXLbf.append("<GET_IMAGE>");



     //Properties

    AXLbf.append("<PROPERTIES>");

    if(background != null){
	if(functionDebug) {
		System.out.println("*********************setting background and trans to " + background);
	}
    AXLbf.append("<BACKGROUND color='" + background + "' transcolor='" + background + "' />");
    }


     //Legend

     AXLbf.append("<LEGEND ");

    if(legTitle != null){
        AXLbf.append("title='" + legTitle + "' ");
    }

    if(legFont != null){
        AXLbf.append("font='" + legFont + "' ");
    }

    if(legWidth != null){
        AXLbf.append("width='" + legWidth + "' ");
    }

    if(legWidth == null){
        AXLbf.append("width='200' ");
    }

    if(legHeight != null){
        AXLbf.append("height='" + legHeight + "' ");
    }


    if(legHeight == null){
        AXLbf.append("height='600' ");
    }

    if(legBackground != null){
        AXLbf.append("background='" + legBackground + "' ");
    }

    if(legBackground == null){
        AXLbf.append("background='255,255,255' ");
    }

    if(legCellSpacing != null){
        AXLbf.append("cellspacing='" + legCellSpacing + "' ");
    }

    if(legTitleFontSize != null){
        AXLbf.append("titlefontsize='" + legTitleFontSize + "' ");
    }

    if(legLayerFontSize != null){
        AXLbf.append("layerfontsize='" + legLayerFontSize + "' ");
    }

    if(legFontSize != null){
        AXLbf.append("titlefontsize='" + legFontSize + "' ");
    }

    AXLbf.append(" />");



   //Envelope

   AXLbf.append("<ENVELOPE minx='" + envXMin + "' miny='" + envYMin + "' maxx='" + envXMax + "' maxy='" + envYMax + "' />");


   //Image size

   AXLbf.append("<IMAGESIZE width='" + String.valueOf(mWidth) + "' height='" + String.valueOf(mHeight) + "' />");

    if(functionDebug) {
        System.out.println("before layerlist");
    }

   //LayerList
   AXLbf.append(this.getLayers().createLayerAXL());

   if(functionDebug) {
       System.out.println("Reached after createLayerAXL");
   }

   //Close Properties

  AXLbf.append("</PROPERTIES>");

  if(getLayers().addedshape != null){
      AXLbf.append(getLayers().addedshape);
  }

  if(getLayers().acetate().AcetateList.size() > 0){
      for(int i = 0; i < getLayers().acetate().AcetateList.size(); i++){
          AXLbf.append(getLayers().acetate().AcetateList.get(i).toString());
      }
  }

  AXLbf.append("</GET_IMAGE>");

  AXLbf.append("</REQUEST>");

  AXLbf.append("</ARCXML>");

  AXLRequest = AXLbf.toString();
  if(functionDebug) {
      System.out.println("sending String"+AXLRequest);
  }
  sendAXLRequest(mapService, AXLRequest);
  parseAXLResponse = AXLResponse;
  getImageAsUrl(parseAXLResponse);
}

  if(getFeatures != false){
      AXLbf.append(AXLConstruct);

      AXLbf.append("</REQUEST>");

      AXLbf.append("</ARCXML>");

      AXLRequest = AXLbf.toString();
      sendAXLRequest(mapService+"&CustomService=query", AXLRequest);
      parseAXLResponse = AXLResponse;
  }
}

  if(geocode == true)
    {
        sendAXLRequest(mapService+"&CustomService=geocode", this.getLayers().AMI.RequestAXL);
        this.getLayers().AMI.ResponseAXL = AXLResponse;
        this.getLayers().AMI.getAMR().ResponseAXL = AXLResponse;
    }

  setServiceName(mapService);
    if(debugOn) {
	System.out.println("Ending refresh,mapURL:" + mapURL);
    }
}

/**
 * public void constructIMAP() creates image map html tags.  These allow mouse tips of features
 * on the map.
 */
public void constructIMAP(){
  StringBuffer imp = new StringBuffer();
  String rX = " ";
  String rY = " ";
  String pX = " ";
  String pY = " ";
  String time = " ";
  String location = " ";
  String magnitude = " ";
  String maptip = " ";

  imp.append("<MAP NAME = 'IMAP'>");

  if(this.getLayers().acetate.getPoints().ptX.size() > 0){
  for(int i = 0; i < this.getLayers().acetate().getPoints().ptX.size(); i++){
      rX = this.getLayers().acetate().getPoints().ptX.get(i).toString();
      rY = this.getLayers().acetate().getPoints().ptY.get(i).toString();
      time = this.getLayers().acetate().getPoints().ptTime.get(i).toString();
      location = this.getLayers().acetate().getPoints().ptLocation.get(i).toString();
      magnitude = this.getLayers().acetate().getPoints().ptMagnitude.get(i).toString();
      maptip = "Magnitude: " + magnitude + " , Time: " + time + " , Location: " + location;

      this.fromMapPoint(rX, rY);

    imp.append("<AREA NAME = '" +  time + "' coords = '" + this.fromMapPointX + "," + this.fromMapPointY + "' alt='" + maptip + "'>");

  }

  iMap = imp.toString();
  }
}

/**
 * public Overviewmap getOV() returns the overview map.
 */

  public Overviewmap getOV(){
        return ovmap;
    }
/**
 * public void sendOVResponse() sends the overview AXL response to the Overviewmap object.
 * Method used internally.
 */
  public void sendOVResponse(){
    getOV().Response = this.AXLResponse;
    getOV().parseOVAXL();
  }

  /**
   * public void sendExtractAXL() sends the extract request axl. It also takes the response
   * and sends it to the Extract Beans parseExtractResponse() method to parse.
   */

  public void sendExtractAXL(String service, String AXL){
      StringBuffer extb = new StringBuffer();
      extb.append("<ARCXML version='1.0'> \n");
      extb.append("<REQUEST>");
      extb.append(AXL);
      extb.append("</REQUEST>");
      extb.append("</ARCXML>");
      extractAXL = extb.toString();
      sendAXLRequest(service,extractAXL);
      AXLResponse = appClient.getResponseAXL();
      getExtract().extractResponseAXL = AXLResponse;
      getExtract().parseExtractResponse(AXLResponse);
  }

  /**
   * public Extract getExtract() creates a link to the Extract object.
   */

  public Extract getExtract(){
      return extract;
  }

  
   public String getClientImageString() {
	return("<input type=image class='imageStyle' src='" + mapURL + "'>");
   }
}

